#!/usr/bin/env python
# zoek de eerste vrije (== niet in een wleiden.conf gedefinieerde) interlink
# range
# lodewijk@wirelessleiden.nl
import re
import sys
import glob
import getrange
import tempfile
import subprocess

OUTFILE = 'network.png'

def make_graph():
	substre = re.compile("^(\$[a-zA-Z][^ =]*) ?= ?'([^']*)';")
	
	
	poel = {}
	
	#XXX: Make parsing global, merge with getrange.get_ranges if possible
	for fname in glob.glob("*/wleiden.conf"):
		substs = {}
		lineNr = 0
		for l in open(fname):
			lineNr += 1
			l = l[:-1]
			match = substre.match(l)
			if match != None:
				substs[match.group(1)] = match.group(2)
			if l.startswith("IP="):
				right = l[3:]
				if '/' not in right:
					addr = right
					mask = 32
				else:
					addr, mask = right.split('/')
					if addr in substs:
						addr = substs[addr]
				try:
					addr = getrange.parseaddr(addr)
					mask = int(mask)
					addr = addr & ~((1 << (32 - mask)) - 1)
					cname = fname.split('/')[0]
					if poel.has_key(addr): 
						poel[addr] += [cname]
					else: 
						poel[addr] = [cname]
				except ValueError, e:
					print "[FOUT] in bestand '%s' regel '%i': %s" % (fname, lineNr, l)

	f = tempfile.NamedTemporaryFile(bufsize=0)
	sys.stderr.write("# Building temponary graph file\n")
	print >> f, "Graph WirelessLeidenNetwork {"
	print >> f ,"""
graph [ fontsize = 36,
        overlap = scalexy,
        splines = true,
      ]
"""
	for addr,leden in poel.iteritems():
		leden = sorted(set(leden))
		for index,lid in enumerate(leden[:-1]):
			for buur in leden[index + 1:]:
				print >> f,'  %s -- %s [label="%s"]' % (lid, buur, getrange.showaddr(addr))
	print >> f, "}"
	sys.stderr.write("# Plotting temponary graph file using graphviz\n")
	retval = subprocess.call(["neato","-Tpng",f.name, "-o", OUTFILE])
	if retval != 0:
		sys.stderr.write("# FAILED [%i]\n" % retval)
		subprocess.call(["cat",f.name])
		exit(1)
	sys.stderr.write("# COMPLETED find your output in %s\n" % OUTFILE)
    

if __name__ == "__main__":
	make_graph()

