#!/usr/bin/env python
# zoek de eerste vrije (== niet in een wleiden.conf gedefinieerde) interlink
# range
# lodewijk@wirelessleiden.nl
import popen2
import re
import sys
import glob

size = 30
if len(sys.argv) < 2:
	print "Gebruik: python getrange.py <interlink|subnet> <size>"
	print "dus voor een /28 interlink is het 'python getrange.py interlink 28'"
	print "en voor een /25 subnet is het 'python getrange.py subnet 25'"
interlink = sys.argv[1] == 'interlink'
size = int(sys.argv[2])
numaddrs = 1 << (32 - size)

substre = re.compile("^(\$[a-zA-Z][^ =]*) ?= ?'([^']*)';")

def parseaddr(s):
	f = s.split('.')
	return (long(f[0]) << 24L) + \
		(long(f[1]) << 16L) + \
		(long(f[2]) << 8L) + \
		long(f[3])

def showaddr(a):
	return "%d.%d.%d.%d" % ((a >> 24) & 0xff, (a >> 16) & 0xff, (a >> 8) & 0xff, a & 0xff)

bezet = {}

for fname in glob.glob("*/wleiden.conf"):
	substs = {}
	for l in open(fname):
		l = l[:-1]
		match = substre.match(l)
		if match != None:
			substs[match.group(1)] = match.group(2)
		if l.startswith("IP="):
			right = l[3:]
			if '/' not in right:
				addr = right
				mask = 32
			else:
				addr, mask = right.split('/')
				if addr in substs:
					addr = substs[addr]
			addr = parseaddr(addr)
			mask = int(mask)
			addr = addr & ~((1 << (32 - mask)) - 1)
			bezet[addr] = 1

i = 0xffffffffL
for k in bezet.keys():
	if k < i:
		i = k


i = 0xac100300
if not interlink:
	i = 0xac110000
while bezet.has_key(i):
	i = i + numaddrs

print "%s/%d:" % (showaddr(i), size),
print " en ".join([showaddr(i) for i in range(i + 1, i + numaddrs - 1)])
