#!/usr/bin/env perl
use Geo::Coordinates::RDNAP qw/from_rd to_rd dms/;


# RD X,Y -> RD Noorderbreedte, Oosterbreedte
# http://web.inter.nl.net/users/F.Kissels/gps/conversie.html

# Little perl to convert genesis files into python config files,
# Which gonna be used for more logic stuff ;-)

#
# Usage: for file in */wleiden.conf; do ./genesis-to-py.pl $file; done > py.conf
do($ARGV[0]) || die;

$interfaces = join(',',keys %config);
if ( ($X =~ /\d+/) and ($Y =~ /\d+/) and ($X > 10) and ($Y > 10)) {
    ($lat, $lon, $h) = from_rd( $X, $Y, 0);
} else {
    $lat = $lon = $h = 0;
}

print <<EOF;
[$nodename]
location = $location
status = $status
latitude = $lat
longitude = $lon
interfaces = $interfaces
x = $X
y = $Y
master_ip = $master_ip
nodetype = $nodetype
nodename = $nodename
configtype = node

EOF


foreach $if (keys %config) {
    print <<EOF;
[$nodename/$if]
EOF
    %tmp = (
        'configtype' => 'interface',
        'dhcp' => 'no',
        'polar' => 'ver',
        'type' => 'wireless',
        'antenna' => 'omni',
        'essid' => 'essid-unused',
        );
    foreach $line  (split('\n',$config{$if})) {
        ($key, $value) = split(/=/,$line);
        if ($key and (lc($key) =~ /^[a-z].*/)) {
            #print "$key : $value\n";
            $tmp{lc($key)} = lc($value);
        }
    }

    foreach $key (keys %tmp) {
        print "$key=$tmp{$key}\n"
    }
    print "\n";
}
