#!/usr/bin/perl -w
#
# Copyright 2005 Stichting Wireless Leiden
# Rick van der Zwet
#

# Config located at other file
my $conf_file="./genesis.conf";
do($conf_file) || die("Cann't open $conf_file");



my $HTML=1;

#laden van tool file
do($toolfile) || die("Cann't open $toolfile");

#gebruik van simple subje om ervoor te zorgen dat de print netjes in het
#programma gestopt kan worden
sub printline {
  print "$_[0] \n";
};

sub filelist {
  foreach $file ( sort @filelist) {
    if( $HTML) {
      print "$file<BR>\n";
    }
    else {
      print "$file\n";
    };
  };
}

sub listnodes {
  opendir(DIR, $ndir) || die "can't opendir $ndir: $!";
  @tmpdirs = grep { /^[^\.]/ && -d "$ndir/$_" } readdir(DIR);
  closedir DIR;
  foreach $dir (sort @tmpdirs) {
    if( not exists($removefromnodelist{$dir}) )
    {
      push(@nodelist, $dir);
    }
    else
    {
    if ( $debug ) { print "'$dir' removed from list\n"; }
    }
  };
  return @nodelist;
}

sub nodelist {
  foreach $node (listnodes( )) {
    if( $HTML) {
      print "$node<BR>\n";
    }
    else {
      print "$node\n";
    };
  };
}

#REQUEST parsen
$request=$ENV{'REQUEST_URI'};
if( $request=~/.*g_list.pl\/(.*)$/) {
  ($node,$file)=split(/\//,$1);
  $title="$node $file";
  if ( $debug ) { print "Node: $node\n"; }
  if ( $debug ) { print "File: $file\n"; }
}
else {
  $title="listing";
};


#controleer wat de browser is
#en zorgen dan er de nodige tags geprint worden
$browser=$ENV{'HTTP_USER_AGENT'};
if( $browser=~/curl|wget|fetch/i) {
  $HTML=0;
  printline("Content-type: text/html\n\n");
}
else {
  $HTML=1;
  printline("Content-type: text/html\n\n");
  printline("<HTML>");
  printline("<TITLE>Genesis $title</TITLE>");
  printline("<BODY BGcolor=white>");
};


#als geen node gespecificeerd dan kijken of svn geupdate is gevraagd
if( $node eq '') {
  if( $ENV{"QUERY_STRING"}=~/update/i) {
    printline("<H2>Please wait while updating svn...</H2><P><PRE>");
    select(STDERR); $| = 1;     # make unbuffered
    select(STDOUT); $| = 1;     # make unbuffered
    system("$svn update $ndir");
    printline("</PRE>");
    printline("<H2>Done.<H2><P>");
    printline("Click <A HREF=$source>here</A>");
    printline("if you're not forwarded automaticly in 5 seconds.<P>");
    printline("<META HTTP-EQUIV=REFRESH CONTENT=5;URL=$source>");
  }
  else {
   g_list( );
  }
}
elsif( $node eq 'filelist' ) {
  filelist( );
}
elsif( $node eq 'nodelist' ) {
  nodelist( );
}
else {
  if( $file eq '') {
      filelist( );
  }
  elsif( $file eq 'config') {
    g_print($hostname);
  }
  else {
    foreach my $tmpFile ( sort @filelist) {
      if( $file eq $tmpFile ) {
        g_generate($file);
      };
    };
  };
};

#plaats de sluit HTML tags
if( $HTML) {
  print <<EOF;
</BODY>
</HTML>
EOF
}


#Het opbouwen van het begin scherm
sub g_list {
  if( $HTML) {
    my $svn_version=svn_version("$ndir");
    if( $svn_version=~/Last Changed Rev: (\d+)/) {
      $revision=$1;
    };
    printline("<H1>Genesis config (revision: $revision):</H1><P>\n<PRE>");
    printline("$svn_version");
    printline("</PRE>");
    printline("<FORM METHOD=get ACTION=$source>");
    printline('<INPUT TYPE="submit" NAME="Update" VALUE="Update">');
    printline("</FORM>");
    printline("<TABLE BORDER=1>");
  };

  @dirs = listnodes( );
  foreach $dir (sort @dirs) {
    if( $dir=~/attic/ ) {
      next;
    };
    my $node = $dir;
    if( ! $HTML ) {
      print "$node\n";
    }
    else {
      printline("<TR><TD><A HREF=g_list.pl/$node/config>$node</A></TD>");
      foreach $file (sort @filelist) {
        printline("<TD><A HREF=g_list.pl/$node/$file>$file</A></TD>\n");
      };
    };
  };
  if( $HTML ) {
    printline("</TABLE><P>");
  };
};



#ophalen svn versie
sub svn_version {
  local($file,$char)=@_;
  local($svn_version);
  $svn_version=`$svn info $file`;
  if( $char ne '' ) {
    $svn_version=~s/^([^$char].*)/$char $1/mgi;
  };
  return($svn_version);
};



#netjes de configuratie printen
sub g_print {
  my $config="$ndir/$node/$configfile";
  parse_config($config);
    
 printline("<H1>Genesis configuratie voor: $node</H1><P>");
 printline("<PRE>" . svn_version($config) . "</PRE><P>");


 my $TP='';
 if( $tproxy !~ m/no/i ) {
   $TP .= "\n";
   $TP .= "Tproxy on cidr range $tproxy";
   $TP .= "<b>WARNING - specification propably wrong - should be a cidr</b>"
   unless $tproxy =~ m/\d+\.\d+\.\d+\.\d+\/\d+/;
 };

 printline("<TABLE BORDER=1><TR><TD COLSPAN=4><PRE>");
 printline("master_ip=$master_ip");
 printline("AGGREGATE=$AGGREGATE");
 printline("");
 printline("gw_open=$gw_open");
 printline("nodetype=$nodetype");
 printline("nodename=$nodename");
 printline("");
 printline("NS_forward=$NS_forward");
 printline("NS_resolv=$NS_resolv");
 printline("");
 printline("location=$location");
 printline("DISK=$DISK");
 printline("");
 printline("X=$X");
 printline("Y=$Y");
 printline("");
 printline("OS=$OS");
 printline("");
 printline("$TP");
 printline("</PRE></TD></TR>");

 foreach $if( sort keys %config) {
   if( $if=~/^(.*):\d+/ ) {
     $subs{$1}++;
   };
 };

 foreach $if( sort keys %config) {
   if( $if=~/^([^:]+)/ ) {
     $mymain=$1;
   }
   else {
     $mymain='';
   };
   
   if( $if!~/:\d+/ ) {
     $main=1;$cc='66'
   }
   else {
     $main=0;
     $cc='cc';
   };
   
   if(! ($ip=$IP{$if}) ) {
     $ip='dhcp?';
   };
   if( $TYPE{$if}=~/wireless/ ) {
     $color="#${cc}FFFF";
   };
   if( $TYPE{$if}=~/ethernet/) {
     $color="#FFFF${cc}";
   };
   
   $cfg=$config{$if};
   $cfg=~s/(.*KEY.*=).*/${1}***********/;
   $cfg=~s/(.*PWD.*=).*/${1}***********/;
   $cfg=~s/(.*CODE.*=).*/${1}***********/;
   $cfg=~s/(.*PASS.*=).*/${1}***********/;

   if( $main) {
     printf "<TR bgcolor=$color><TD ROWSPAN=%d VALIGN=TOP><B>$if</TD>\n",(1+$subs{$if})*3,$subs{$if};
     $c=4;
   }
   else {
     $c=3;
     print "<TR bgcolor=$color>";
   };
   $cfg=~s/</&lt;/gi;
   $cfg=~s/>/&gt;/gi;

   printline("<TD>$if</TD><TD><B>$ip</TD><TD>$DESC{$if}($SDESC{$if})</TD>");
   printline("<TR><TD COLSPAN=$c><PRE>");
   printline("$cfg");
   printline("</PRE></TD>");
   printline("<TR><TD COLSPAN=$c>&nbsp;</TD>");
 };
 printline("</TABLE>");
};



#Generen config
sub g_generate {
  my $file=$_[0];
  $config="$ndir/$node/$configfile";
  $svn_versiont=svn_version($toolfile,$char);
  $svn_versionc=svn_version($config,$char);

  if( $svn_versiont=~/Last Changed Rev: (\d+)/ ) {
    $tool_rev=$1;
  };
  if( $svn_versionc=~/Last Changed Rev: (\d+)/ ) {
  $config_rev=$1;
  };

  if( $tool_rev >= $config_rev) {
    $svn_version=$svn_versiont . $svn_versionc;
  }
  else {
    $svn_version=$svn_versionc;
  };

  if( $HTML) {
    printline("<H1>Genesis $file voor: $hostname</H1><P>");
  };

  parse_config($config);
  $pr=do_it($file);


  if( $HTML ) {
    $pr=~s/</&lt;/gi;
    printline("<PRE>$pr</PRE>");
  }
  else {
    print $pr;
  };
};
