#!/usr/bin/perl -w
#
# Copyright 2005 Stichting Wireless Leiden
# maart 2004 rick@wirelessleiden.nl
#

# Config located at other file
my $conf_file="/home/genesis/tools/genesis.conf";
do($conf_file) || die("Cann't open $conf_file");
################ END OF CONFIG ##########################

#variablen
my $time=gmtime();
my $source=`/bin/hostname`;
chomp($source);


#slurp IP berekeningen info
do ("$IP_pmPath") || die ("Cann't open $IP_pmPath");
#slurp dns info
do ("$dnsheader_confPath") || die ("Cann't open $dnsheader_confPath");


#zoek uit of het master_ip addr voorkomt in de configs
#belangrijk van aliassen
sub master_ipNotUsed {
  if( $debug ) {
    print "running master_ipNotUsed...\n";
  }
  foreach my $if (keys %config) {
    if( $IP{$if} =~ /([0-9\.]+).*/ ) {
      if( $1 eq $master_ip ) {
        return(0);
      };
    };
  };
  return(1);
};



sub genHeader {
  my $comment = $_[0];
  my $output =
  "$comment This file specific to wireless\n" .
  "$comment leiden. Please make all changes in Genesis.\n" .
  "$comment\n" .
  "$comment Generated by $source\n" .
  "$comment on $time\n" .
  "$comment\n" .
  "$comment  $author\n" .
  "$comment\n\n\n";
  return ($output);
};


sub txtconfig {
  my $output = "";
  foreach $interface (keys %config) {
    $output .= $config{$interface};
  };
  return($output);
};


sub dhcpd_conf {
  my $output = genHeader("#");
  $output .=
  "option domain-name \"$domain\";\n" .
  " \n" .
  "default-lease-time 7200;\n" .
  "max-lease-time 2592000;\n" .
  "\n" .
  "ddns-update-style none;\n" .
  "\n" .
  "# Hack for the WET11\n" .
  "#\n" .
  "always-broadcast on;\n" .
  "\n" .
  "option domain-name-servers ${master_ip};\n" .
  "\n";

  foreach my $interface (sort keys %config) {
    if( $interface =~ /^[a-z]+[0-9]+$/i ) {
      (my $ip, my $netmask) = split('/', $IP{$interface});
      my $subnet = IP::toSubnet($netmask);
      my $broadcast = IP::getBroadcastAddr($ip, $subnet);
      my $network = IP::getNetworkAddr($ip, $subnet);
      
      $output .=
      "# $interface $DESC{$interface}\n";
      
      if ( $DHCP{$interface} =~ /[0-9]+\-[0-9]+/i ) {
        my $dhcp_part = $ip;
        $dhcp_part =~ s/[0-9]+$//;
        (my $dhcp_start, my $dhcp_stop) = $DHCP{$interface} =~ /([0-9]+)\-([0-9]+)/i;
        $dhcp_start = $dhcp_part . $dhcp_start;
        $dhcp_stop = $dhcp_part . $dhcp_stop;
        $output .=
        "subnet $network netmask $subnet {\n" .
        "  range $dhcp_start $dhcp_stop;\n" .
        "  option broadcast-address $broadcast;\n" .
        "  option subnet-mask $subnet;\n" .
        "  option routers $ip;\n" .
        "}\n" .
        "\n";
      }
      else {
       $output .=
       "subnet $network netmask $subnet {not authoritative; }\n" .
       "\n";
      };
    };
  };
  
  return($output);
};

sub named_conf {
  my $output = genHeader("#");
  $output .=
  "options {\n" .
  "  directory \"/var/db/namedb\"\;\n" .
  "  forwarders {\n";
  foreach my $forward (@forwarder) {
    $output .= "$forward;\n";
  };
  $output .= 
  "  };\n" .
  "};\n" .
  "\n" .
  "\n" .
  "zone \"\.\" {\n" .
  "  type hint;\n" .
  "  file \"/etc/namedb/named.root\"\;\n" .
  "}\;\n" .
  "\n" .
  "zone \"0\.0\.127\.IN-ADDR.ARPA\" {\n" .
  "  type master\;\n" .
  "  file \"/etc/namedb/localhost.rev\"\;\n" .
  "}\;\n" .
  "\n" .
  "zone \"1.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.IP6.INT\" {\n" .
  "  type master\;\n" .
  "  file \"/etc/namedb/localhost-v6.rev\"\;\n" .
  "};\n" .
  "\n";


  foreach my $tmpZone (sort keys %zone) {
    my $dnsZone = $zone{$tmpZone};
    $output .= 
    "zone \"$tmpZone\" {\n" .
    "  type slave\;\n" .
    "  file \"slave-$tmpZone\"\;\n" .
    "  masters {\n";
    foreach my $tmpIP (sort @$dnsZone) {
      $output .= "    $tmpIP\;\n";
    };
    $output .= 
    "  };\n" .
    "};\n" .
    "\n";
  };
  
  return($output);
};



sub rc_node_local {
  my $output = genHeader("#");
  my $masterNotUsed = master_ipNotUsed();
  $output.=
  "hostname=\"$nodetype$nodename.$domain\"\n" .
  "location=\"$location\"\n" .
  "\n";

  if( $tproxy ) {
    if( $tproxy =~ m/\d+\.\d+\.\d+\.\d+\/\d+/ ) {
      $output .=
      "# Tproxy is ran on this system\n".
      "tproxy_enable='YES'\n".
      "tproxy_range='$tproxy'\n".
      "\n";
    }
    elsif( $tproxy !~ m/no/i ) {
      $output .= "# WARNING - specification propably wrong - check " .
      "genesis. It should be a pure CIDR\n";
    };
  };
  
  $output .= "ifconfig_lo0_alias0=\"inet 172.31.255.1/32\"\n";
  if( $masterNotUsed ) {
    $output .= "ifconfig_lo0_alias1=\"inet $master_ip/32\"\n\n";
  }
  else {
    $output .= "#ifconfig_lo0_alias1=\"inet $master_ip/32\"\n\n";
  };

  foreach my $interface (sort keys %config) {
    (my $if, my $number) = split(/:/, $interface);
    if( defined $number ) {
      $output .= "ifconfig_$if\_alias$number=\"inet $IP{$interface}\"";
    }
    else {
      $output .= "ifconfig_$if=\"inet $IP{$interface}\"\t";
    };
    ## add some extra link information
    $output .= "\t# $DESC{$interface}\n";
  };
  return($output);
};

sub rc_local {
  my $output = genHeader("#");
  foreach my $if (sort keys %config) {
    if( ($if =~ /^wi[0-9]$/i) and ($TYPE{$if} =~ /wireless/i) ) {
      $output .=
      "$wicontrol -i $if -s $SDESC{$if}    # Nickname\n" .
      "#$wicontrol -i $if -t 7             # TXrate\n" .
      "$wicontrol -i $if -P 0              # PowerSave\n" .
      "$wicontrol -i $if -Z                # Zero SNR cache\n";
      if( $MODE{$if}=~/master/i ) {
        $output .=
        "$wicontrol -i $if -p 6            # hostap mode\n" .
        "$wicontrol -i $if -c 1            # broadcasting essid on\n" .
        "$wicontrol -i $if -n $ESSID{$if}  # network name\n" .
        "$wicontrol -i $if -q $ESSID{$if}  # ESSID\n" .
        "$wicontrol -i $if -f $CHANNEL{$if}# Channel\n";
      }
      else {
        $output .= 
        "$wicontrol -i $if -p 1            # Client mode (managed)\n" .
        "$wicontrol -i $if -n $ESSID{$if}  # ESSID\n" .
        "# No channel - client follows\n" .
        "# $wicontrol -i $if -f 0          # Channel\n";
      };
    $output .= "\n";
    };
  };
  return($output);
};



sub resolv_conf {
  my $output = genHeader"#";

  $output .= 
  "search wleiden.net.\n" .
  "nameserver 127.0.0.1\n" .
  "\n";

  foreach my $if (sort keys %config) {
    if( exists $POINT_TO_POINT{$if} ) {
      foreach my $ip ($POINT_TO_POINT{$if}) {
        $output .= "nameserver $ip # $DESC{$if}\n";
      };
    };
  };
  return($output);
};


# JB: snmpd.local.conf was nodig voor ospf. kan weg.
# 
#sub snmpd_local_conf {
#  my $output = genHeader("#");
#  my $masterNotUsed = master_ipNotUsed();
#  $output .=
#  "# Location of the physical node.\n" .
#  "#\n" .
#  "syslocation \"$location\"\n" .
#  "#\n" .
#  "# Maintained by\n" .
#  "syscontact \"$contact\"\n" .
#  "\n";
#
#  if( $DISK =~ /flash/i ) {
#    $output .= "# Verify that disk is RO\n";
#    $output .= "sh diskro /usr/local/sbin/diskro.sh\n\n";
#  };
#
#  $output .= "agentaddress 161,tcp:161\n";
#
#  if( $masterNotUsed ) {
#    $output .= "agentaddress $master_ip\n";
#  };
#  
#  foreach my $if (keys %config) {
#    if( $IP{$if} =~ /([0-9\.]+).*/ ) {
#      $output .= "agentaddress $1\n";
#    };
#  };
#  return($output);
#};



sub parse_config {
  my $workingfile = $_[0];
  do($workingfile) || die("Cann't open/parse $workingfile");
  foreach my $if (keys %config) {
    my $cfg=$config{$if};
    while ($cfg) {
      $cfg=~s/^([^\n\r]+)[\r\n]*//m;
      my $line=$1;
      $line=~s/\s*#.*//;
      if (((my $name, my $value)=split(/=/,$line)) eq 2) {
        my $doit="if (exists(\$$name\{\"$if\"\})) {\$$name\{\"$if\"\}.=\";$value\";} else {\$$name\{\"$if\"\}.=\"$value\";}";
        eval($doit);
      };
      $cfg=~s/[\r\n]*$//m;
    };
  };
};

sub authorized_keys {
  my $output = genHeader("#");
  if( -e "$global_keyPath" ) {
    open( GLOBAL, "$global_keyPath" ) || die ("Cann't open $global_keyPath");
      $output .= join("", <GLOBAL>);
    close( GLOBAL );
  }
  else {
    $output .= "# No $global_keyPath\n";
  };
 
  if( -e "$ndir/$nodetype$nodename/$ssh_file" ) {
    open( NODE, "$ndir/$nodetype$nodename/$ssh_file" ) || die ("Cann't open $home/$nodename/$ssh_file");
      $output .= join("", <NODE>);
    close( NODE );
  }
  else {
    $output .= "# No $ndir/$nodetype$nodename/$ssh_file\n";
  };
  
  return($output);
};

sub do_it {
  my $file = $_[0];
  my $body = "";
  
  $file =~ s/\./_/g;
  $body=&$file;
  return($body);
};

if( exists $ARGV[0] ) {
  if( exists $ARGV[1] ) {
    parse_config($ARGV[0]);
    print do_it($ARGV[1]);
  }
  else {
    print "Usage `perl wleiden.pl 'inputfile' 'outputfile'`\n";
  };
};

1;
