#!/usr/bin/perl -w
#
#Tooltje om de wleiden files er generiek uit te laten zien
#
#Rick van der Zwet (rick@wirelessleiden.nl)
use IP;

my $debug = 0;

#maak een mooi systeem met hash aanroepen om snel gegevens te verwerken
sub parse_config {
	foreach my $id (sort keys %config) {
		my $rawData = $config{$id};
		$rawData =~ s/#.*\n/\n/g;                  #wegslopen comments
		$rawData =~ s/\s*[\r,\n]+\s*/:::/g;        #spaties+enter+spaties vervangen door :::
		$rawData =~ s/^::://;                      #::: aan het begin weghalen
		$rawData =~ s/:::$//;                      #::: aan het eind weghalen
		my @configArray = split( /:::/, $rawData); #array er van maken
		foreach $line (@configArray) {
			(my $name, my $value) = split( /\=/, $line);
			$$name{$id} = $value;
		}
	}
}


sub genericConfig {
	my $configfile = $_[0];
	open( CONF, "> $configfile");
	print CONF <<EOP;
#
# Config cleaned up bij configcleaner
# config for $nodetype$nodename
#
\$master_ip='$master_ip';
\$nodetype='$nodetype';
\$nodename='$nodename';
\$status='$status';

\$location="$location";
\$X='$X';
\$Y='$Y';
\$labelpos='$labelpos';

\$OS='$OS';

EOP
	
	if(! $static_dhcp[0] eq "" ) {
		for( my $ctr=0; $ctr < scalar(@static_dhcp); $ctr++ ) {
			print CONF "\$dhcp_static[$ctr]='$static_dhcp[$ctr]';" . "\n";
		}
	}

	foreach my $key (sort keys %config) {
		my $keyTerminator = $key;
		$keyTerminator =~ tr/a-z/A-Z/;
		$keyTerminator =~ s/://;
		print CONF <<EOP;

\$config{'$key'}=sprintf <<$keyTerminator;
  IP=$IP{$key}
  TYPE=$TYPE{$key}
EOP

		if( lc($TYPE{$key}) eq "wireless" ) {
			print CONF <<EOP;
  MODE=$MODE{$key}
  ESSID=$ESSID{$key}
  CHANNEL=$CHANNEL{$key}
EOP
		}

		print CONF <<EOP;
  SPEED=$SPEED{$key}

  DESC=$DESC{$key}
  SDESC=$SDESC{$key}

  POINT_TO_POINT=$POINT_TO_POINT{$key}
  DHCP=$DHCP{$key}
EOP

		if( lc($TYPE{$key}) eq "wireless" ) {
			print CONF <<EOP;

  POLAR=$POLAR{$key}
  ANTENNA=$ANTENNA{$key}
  GAIN=$GAIN{$key}
  DIRECTION=$DIRECTION{$key}
  CABLE=$CABLE{$key}
  HEIGHT=$HEIGTH{$key}
EOP
		}
		print CONF "$keyTerminator" . "\n";
	}
	print CONF "\n" . "# End of Config File" . "\n";
	close ( CONF );
}


foreach my $file (@ARGV) {
	if($debug) {
		$file_output = "test.conf";
	}
	else
		{$file_output = $file;
	}
	print "Working on $file...\n";
	@$_ = [] foreach qw(static_dhcp);
	$static_dhcp[0]="";
	$$_ = "" foreach qw(location master_ip gw_open nodetype nodename
                      OS status X Y N E OS DISK AGGREGATE);
	%$_ = () foreach qw(config TYPE IP DESC SDESC SPEED DHCP DHCP_STATIC
                            OSPF_BROADCAST OSPF_NEIGHBORS MODE ESSID CHANNEL
                            POLAR ANTENNA GAIN DIRECTION BEAMWIDTH CABLE
                            HEIGHT ROUTE);
	do($file) || die("Cann't open file");
	print "\t Parsing config...";
	parse_config;
	print "DONE\n";
	print "\t Applying generic rules ...";
	genericConfig($file_output);
	print "DONE\n";
}

