
#
#
#  aug 2002, jasper\@WirelessLeiden.NL
#


$now=localtime($unow=time());

$config='/etc/wl/wleiden.conf';
$domain='wLeiden.NET';

$ifconfig='/sbin/ifconfig';
$iwconfig='/sbin/iwconfig';
$ipchains='/sbin/ipchains';
$indexmaker='/usr/bin/indexmaker';
$sroute='/sbin/route';
$OSPFPWD='huppel';
$separator=';';
$author='feb 2003 jasper@WirelessLeiden.NL';
$wicontrol='/usr/sbin/wicontrol';

if ($functions_only) {goto functions;}
$source='/etc/wl/wleiden.pl';

do($config) || die;
parse_config();


$hostname=`/bin/hostname |cut -d . -f 1`;chomp($hostname);
$maxmask= pack("CCCC", 255, 255, 255, 255);


if (! $ARGV[0]) {die "use start/stop/startall";}

if ($ARGV[1]=~/debug/i) {$DEBUG=1;}
if ($ARGV[0]=~/start/i)
{

######################################################################
do_it();

open_files();
$nwcfg.="$indexmaker /etc/mrtg/mrtg.cfg> /var/www/html/mrtg/index.html 2> /dev/null\n";

print_files();close_files();

system("chmod 755 /etc/wl/nwcfg.sh;/etc/wl/nwcfg.sh");

if ($DEBUG) {die "DEBUGGING!";}

if ($DEBUG) {print "\nDEBUG: making mrtg index.\n";}

changeline("/etc/sysconfig/dhcpd","DHCPDARGS","DHCPDARGS=\"$dhcpints\"");

#if ($DEBUG) {print "\nDEBUG: reloading firewall.\n";}
#$nwcfg.="/usr/local/sbin/firewall\n";

if ($DEBUG) {print "\nDEBUG: restarting daemons.\n";}

if ($ARGV[0]=~/startall/) {$restart='restart';}
else  {$restart='condrestart';}
$nwcfg.="/etc/init.d/dhcpd $restart\n";
$nwcfg.="/etc/init.d/zebra $restart\n";
$nwcfg.="/etc/init.d/ospfd $restart\n";
$nwcfg.="/etc/init.d/httpd $restart\n";
$nwcfg.="/etc/init.d/named $restart\n";


########################################################################
} else  # geen start -> stop
{
  $nwcfg.="$ifconfig lo:1 down\n";

  foreach $if (keys %config)
  {
     $nwcfg.="$ifconfig $if down\n";
  }
}


exit;

########################################################################

functions:

$ahum=1;

sub do_it
{
  if ($OS=~/FreeBSD/i) {$FreeBSD=1;}
  elsif ($OS=~/Linux/i) {$Linux=1;}

init_files();

#system("/sbin/modprobe ipv6");
#system("/sbin/modprobe ipchains");

$nwcfg.="$ifconfig lo:1 down\n";
#print "ifconfig lo:1 $master_ip\n";
#$nwcfg.="$ifconfig lo:1 $master_ip netmask 255.255.255.255\n";	# altijd up!

$last='';
foreach $if (sort {$b <=> $a} keys %config)
{
  if ($TYPE{$if}=~/wireless/) {$last=$if}
} if ($last) {iwconfig("$last &> /dev/null");} # Laatste het eerste...

$keys=1;
foreach $if (sort keys %config)
{
   if ($if=~/^([^:]+):(\d+)/) {$mymain=$1;$mysub=$2;} else {$mymain='';}

   if ($functions_only<1) {print "Doing interface: $if IP: $IP{$if}\n";}

   if ($if!~/:\d+/) {$main=1;} else {$main=0;}

					##################### DOWN
   if ($DOWN{$if}=~/yes/) 
   {   print "$if configured DOWN.\n";
       $nwcfg.="$ifconfig $if 127.0.0.1 down\n";

       if ($main)
       {       
       $zebra1.=sprintf <<EOZ3;

interface $if
 description $DESC{$if}
 ip address 127.0.0.1/0
 shutdown

EOZ3
       $ospfd2{$if}.=" interface $if\n\n";
       }
       next;   # Interface down.
   }
					##################### DOWN
   if ($main)
   {
    $if=~/(\d+)/;$ifnum=$1;
    $nick="${nodename}$ifnum.$domain";

    if ($TYPE{$if}=~/wireless/) 
    {

     if ($SDESC{$if}) {$nick="$SDESC{$if}.$nick";}
#print "$nick\n";
     if (iwconfig("$if mode $MODE{$if}"))
     {
      if ($DEBUG) {print "\nDEBUG: iwconfig $if mode $MODE{$if} essid $ESSID{$if} nick $nick ap $AP{$if} channel $CHANNEL{$if} sens $SENS{$if} txpower $TXPOWER{$if} rate $RATE{$if}\n";}
      iwconfig("$if essid $ESSID{$if}");
      iwconfig("$if nick $nick");

     $freebsd.=sprintf<<EOFB33;
$wicontrol -i $if -s $nick	 # Nickname
#$wicontrol -i $if -t 7		 # TXrate
$wicontrol -i $if -P 0		 # PowerSave
$wicontrol -i $if -Z		 # Zero SNR cache
EOFB33
      if ($MODE{$if}=~/master/i)
      {
     $freebsd.=sprintf<<EOFB3;
$wicontrol -i $if -p 6		 # hostap mode
$wicontrol -i $if -n $ESSID{$if} # network name
$wicontrol -i $if -q $ESSID{$if} # ESSID
$wicontrol -i $if -c 1		 # broadcasting essid on
EOFB3
      } else {
     $freebsd.=sprintf<<EOFB4;
$wicontrol -i $if -p 1		 # Client mode (managed)
$wicontrol -i $if -n $ESSID{$if} # ESSID
EOFB4
      }
      if ($AP{$if}) 		{iwconfig("$if ap $AP{$if}");}
      
if ($MODE{$if}=~/master/) { 
	if ($CHANNEL{$if})  {
		$freebsd.="$wicontrol -i $if -f $CHANNEL{$if}		# Channel\n";
	} else {
		$freebsd .= "# WARNING  - master but no channel defined.\n";
	};
} else {
	$freebsd.="# No channel - client follows\n# $wicontrol -i $if -f 0		# Channel\n";
}
				
      if ($SENS{$if}) 		{iwconfig("$if sens $SENS{$if}");}
      if ($TXPOWER{$if}) 	{iwconfig("$if txpower $TXPOWER{$if}");}
      if ($RATE{$if}) 		{iwconfig("$if rate $RATE{$if}");}
     } #else { print "ERROR: Could not configure interface $if\n";next;}

     $rcconf.="\nifconfig_$if=\"inet $IP{$if} -promisc\"\n";
     #$rcconf.="ifconfig_$if=\"inet $IP{$if} -promisc \"\n  ssid $ESSID{$if} \\"\n";
     #if ($CHANNEL{$if}) 	{$rcconf.="  channel $CHANNEL{$if}";}
     #$rcconf.="\\\n  stationname $nick\"\n";
     #if ($MODE{$if}=~/master/) 		{$rcconf.="#mediaopt hostap\n";}
     #$rcconf.="\n";

     $freebsd.="\n";
    } # if wireless
    mrtg1();
    if ($OS=~/FreeBSD/)
{
       $ospfd2{$if}.=sprintf <<EOO2;

interface $if
 ip ospf message-digest-key 1 md5 $OSPFPWD
 ip ospf authentication message-digest
 ip ospf dead-interval 180
EOO2

   $keys++;  

      $zebra.=sprintf  <<EOZ2;

interface $if
 description $DESC{$if}
 no shutdown
EOZ2
}

    }                     ######################   MAIN

    if ($OS=~/Linux/)
{
       $ospfd2{$if}.=sprintf <<EOO21;

interface $if
 ip ospf message-digest-key 1 md5 $OSPFPWD
 ip ospf authentication message-digest
EOO21
   $keys++;  

      $zebra.=sprintf  <<EOZ21;

interface $if
 description $DESC{$if}
 no shutdown
EOZ21
}

   if ($IP{$if})
   {
    $zebra.=sprintf " ip address $IP{$if}\n";
    ($ip,$netmask,$broadcast,$network,$width)=calc_ip($IP{$if});
    if ($netmask == '0.0.0.0') 
{print "Forgot netmask in config $hostname $if: $IP{$if}!\n";
die "Forgot netmask in config $hostname $if: $IP{$if}!\n";
}

#    if ($DEBUG) {print("\nDEBUG: $ifconfig $if $ip netmask $netmask broadcast $broadcast up\n");}
    if ($DEBUG) {print("\nDEBUG: $if $ip $netmask $network $broadcast\n");}

    if (! $main) {$nwcfg.="$ifconfig $mymain up\n";}
    $nwcfg.="$ifconfig $if $ip down\n";
    $nwcfg.="$ifconfig $if $ip netmask $netmask broadcast $broadcast up\n";
    if ($main)
    {
	if ($TYPE{$if}!~/wireless/) {$rcconf.="\nifconfig_$if=\"inet $IP{$if}\"\n";}
    } else {$rcconf.="ifconfig_${mymain}_alias${mysub}=\"inet $IP{$if}\"\n";}
   }
   if (($OS=~/Linux/) || ($main)) {$zebra.= "\n";}

   if ($ROUTE{$if})
   {
	if ($DEBUG) {print "\nDEBUG: ROUTE: $ROUTE{$if}\n";}

	foreach $r (split(/$separator/,$ROUTE{$if}))
	{
	   if ($DEBUG) {print "\nDEBUG: ROUTE2: $r\n";}
	    
	   $r=~/([^\/ ]+)\/?(\S+)\s+(\S+)/;
	   $R="$1/$2";$gw=$3;$nm=$2;
	   ($route,$r_netmask,$r_broadcast,$r_network,$r_width)=calc_ip($R);
	   if ($R eq '0.0.0.0/0') 
	   {   $doit="$sroute add default gw $gw dev $mymain";
	       $rcconf.="\ndefaultrouter=\"$gw\"\n\n";
	   }
           elsif ($nm eq 32)      {$doit="$sroute add $route gw $gw dev $mymain";}
	   else {$doit="$sroute add -net $route netmask $r_netmask gw $gw dev $mymain";}

	   if ($DEBUG) {print "\nROUTE3: $doit\n";}
	   $nwcfg.="$doit\n";
	   if ($R eq '0.0.0.0/0') {$ospfd3.=" default-information originate\n"}
	   else
	   {
		$area=get_area($R);
		$ospfd4.="! static route $R\nnetwork $R area $area\n\n";
		$NW{$area}.="$network/$width ";
	   }
	   $zebra.="ip route $r\n";
	}	
   }

   ($ip,$netmask,$broadcast,$network,$width)=calc_ip($IP{$if});
   if (($DHCP{$if}) && ($DHCP{$if}!~/off|no/i))  
   {
       ($from,$upto)=split(/-/,$DHCP{$if});
       $ip=~/(^\d+\.\d+\.\d+)\.\d+$/;
       $dip=$1;
       $dhcp.=sprintf <<EOD2; 

	#
	#  $if $DESC{$if}
	#
	subnet $network netmask $netmask {
  		range  $dip.$from $dip.$upto;
  		option broadcast-address $broadcast;
  		option subnet-mask $netmask;
  		option routers $ip;
		$DHCP_STATIC{$if}
	}   

EOD2
	if ($dhcpints!~/$mymain/) {$dhcpints.=" $mymain";}
     }  # DHCP
     else
     {
	if ( ($main) ) #|| ($DHCP{$mymain}=~/off|no/i))
	{  # niet als main wel dhcp heeft.
	  $dhcp.="subnet $network netmask $netmask {not authoritative; } # $if\n\n";
	}
     }
     if ($OSPF_NEIGHBORS{$if}=~/no/i) 
     {
	if ($main) {$OSPF_PASSIVE{$if}=1;}
     }

     if ($OSPF_AREA{$if}!~/no/i)
     {
    	($ip,$netmask,$broadcast,$network,$width)=calc_ip($IP{$if});

	  if ($IP{$if}) 
	    { 
#		if (($OSPF_NEIGHBORS{$if}!~/no/) || 
		if ($OSPF_AREA{$if} eq '') {$area=get_area($network);}
		else {$area=int($OSPF_AREA{$if});}
		 
		$ospfd4.="! $if ($DESC{$if})\nnetwork $network/$width area $area\n\n";
		$NW{$area}.="$network/$width ";
	    }

	 if ($OSPF_BROADCAST{$if}=~/no/i)
	 {
	   if ($main)
	   {
#if ($DEBUG) {print "DEBUG: OSPF_NEIGHBORS{$if}: ($OSPF1_NEIGHBORS{$if})\n";}
	   $OSPFD_NONBROADCAST{$if}=1;
	   }
	   if ($OSPF_NEIGHBORS{$if}!~/no/i)
           {
	     foreach $n (split(/[\s$separator]+/,$OSPF_NEIGHBORS{$if}))
             {
                if ($DEBUG) {print "DEBUG: OSPF2_NEIGHBOR{$if}: [$n]\n";}
                $ospfd5.="! $if link: $SDESC{$if}\n neighbor $n\n\n";
	     }
	     if ($main) {$OSPF_PASSIVE{$if}=0;}
	     else {$OSPF_PASSIVE{$mymain}=0;}
           } #ospf_neighbors
	 }
    	
     } # ospf_area

     if ($POINT_TO_POINT{$if})
     {
	   foreach $p (split(/$separator/,$POINT_TO_POINT{$if}))
	   {
		mrtg2();
	   } #foreach $pointtopoint	
     } # pointopoint
} # foreach if

foreach $if (sort keys %config)
{
   if ($if!~/:\d+/) {$main=1;} else {$main=0;}
   if ($main)
   {
	$ospfd2.=$ospfd2{$if};
	if ($OSPF_PASSIVE{$if})
	{
	  $ospfd22.=" passive-interface $if\n";
	}
	if ($OSPFD_NONBROADCAST{$if})
	{
	   $ospfd2.= " ip ospf network non-broadcast\n";
	}
	if ($OSPF_COST{$if})
	{
	  $ospfd2.=" ip ospf cost $OSPF_COST{$if}\n";
	}

   }
}

 $zebra.= "\n\nlog file /var/log/zebra.log\n\n";

foreach $area (keys %NW)
{
  if ($area eq 0) {next;}
  $nwa=0xffffffff;
  foreach $nw (split(/\s+/,$NW{$area}))
  {
     ($ip,$width)=split(/\//,$nw);
     ($a,$b,$c,$d)=split(/\./,$ip);
     ($II)=($a<<24)+($b<<16)+($c<<8)+$d;
     if ($width eq 32) {$nm=0xffffffff;}
     else {$nm=0xffffffff-1<<(31-$width);}

     $II=$II & $nm;
     $nwa=$nwa & $II;
#     $ospfd.=sprintf ("NW-$area: $nw ==> %08x enne %08x\n",$II,$nwa);
  }
  $nwa=itoadr($nwa);

  if ($AGGREGATE) {$agg=$AGGREGATE;}
  else {$agg=21;}

  if (($nwa!~/^172\.16\./) && ($area > 0))
  { $ospfarea.="area $area range $nwa/$agg substitute $nwa/$agg\n"; }

  $ospf21.="! area $area authentication message-digest\n";
}


$ospfd.=sprintf <<EOOL;

!  ================>   interfaces  <================

$ospfd2

!  ================>   OSPF router  <================
router ospf
 ospf router-id $master_ip
 $ospfd21

 passive-interface lo0
$ospfd22

!default
$ospfd3

$ospfarea

!  ================>   networks  <================
$ospfd4

!  ================>  neighbors  <================
$ospfd5

log file /var/log/ospf.log

EOOL
# $rcconf.="\n\n" . $freebsd;
}

sub get_area
{
  local($IP)=@_;
  local($range);
  local($ip,$netmask,$broadcast,$network,$width);
  local($a,$b,$c,$d)=split(/\./,$IP);
  local($II)=($a<<24)+($b<<16)+($c<<8)+$d;
  local($ii,$ip,$nm,$I2);

#  for ($i=0;$i<=$maxareas;$i++)
#  {
#    $ii=$II[$i];
#    $nm=$NM[$i];
#    $I2=$II & $nm;    
##$ospfd.=sprintf "i=$i\t $RANGE[$i]\t ii=$ii\t nm=$nm\t I2=$I2 $II $IP $a,$b,$c,$d\n";
#    if ($I2 == $ii) {return($AREA[$i]);}    
#  }
#  return(12345);

   $area=1;
   if ($b eq 16) {$area=0;}
   elsif ($c < 128) {$area=($b * 10)}
   else {$area=(1+($b*10));}
   if ($area > 255) {$area/=10;}
   return($area);
}


sub read_areas
{
   $maxareas=0;
   open(AC,"$home/areas.conf") || die;
   while (<AC>)
   {
	chomp();
	s/#.*$//;
        if (! $_) {next;}
	($area,$range,$desc,$counter,$junk)=split(/\s+/);
	$AREA[$maxareas]=$area;
	$RANGE[$maxareas]=$range;
	$DESC[$maxareas]=$desc;

        ($ip,$width)=split(/\//,$range);
        ($a,$b,$c,$d)=split(/\./,$ip);
        $ii=($a<<24)+($b<<16)+($c<<8)+$d;
    
        if ($width eq 32) {$nm=0xffffffff;}
        else {$nm=0xffffffff-1<<(31-$width);}
        $II[$maxareas]=$ii;
        $NM[$maxareas]=$nm;

	$maxareas++;
   }
   close(AC);
}

sub parse_config
{
  foreach $if (keys %config)
  {
     $cfg=$config{$if};
if (! $html) {print "Parsing interface: $if\n";}
     while ($cfg)
     {
	$cfg=~s/^([^\n\r]+)[\r\n]*//m;
	$line=$1;
	$line=~s/\s*#.*//;
	if ((($name,$value)=split(/=/,$line)) eq 2)
	{
	   if ($name eq 'ESSID') {$value=lc($value);}
#print "VAL($name)=$value\n";
	   $doit="if (exists(\$$name\{\"$if\"\})) {\$$name\{\"$if\"\}.=\"$separator$value\";} else {\$$name\{\"$if\"\}.=\"$value\";}";
#print "DOIT: [$doit]\n";
	   eval($doit);
	}
#print "CFG:[$cfg]\n";
	$cfg=~s/[\r\n]*$//m;
     }
  }
if ($functions_only<1) {print "Done parsing config.\n";}
}

sub iwconfig
{
  local($line)=@_;
  $nwcfg.="$iwconfig $line\n";

}

sub ipchains
{
  local($line)=@_;
  return(system("$ipchains $line"));
}

#($a,$b,$c,$d) = unpack('C4',$addr[0]);

#$IP = pack("CCCC", 152, 2, 128, 184);  # create IP address
#($var1, $var2, $var3, $var4) = unpack("CCCC", $IP);  #inverse of the above



sub calc_ip
{  local($i)=@_;
  local($a,$b,$c,$d);
  local($ip,$width)=split(/\//,$i);
  local($a,$b,$c,$d)=split(/\./,$ip);
  local($ii)=($a<<24)+($b<<16)+($c<<8)+$d;

  if ($width eq 32) {$nm=0xffffffff;} 
  else {$nm=0xffffffff-1<<(31-$width);}
  $nw=($ii & $nm);
  $br=$nw | (0xffffffff & ~$nm);
  $netmask=itoadr($nm);; 
  $broadcast=itoadr($br);; 
  $network=itoadr($nw); # $i=itoadr($ii);

#  printf "ip=$ip|width=$width|nm=%0x|$netmask|br=%0x|$broadcast|$i|\n",$nm,$br;

  return($ip,$netmask,$broadcast,$network,$width);
}

sub itoadr
{
  local($ip)=@_;
  local($a,$b,$c,$d);
  $a=($ip & 0xff000000) >> 24;
  $b=($ip & 0x00ff0000) >> 16;
  $c=($ip & 0x0000ff00) >> 8;
  $d=($ip & 0x000000ff);
  return("$a.$b.$c.$d");
}

sub changeline
{
   local($file,$old,$new)=@_;
   open(OLD,$file) || die "Could not open old file: $file\n";
   open(NEW,">$file.genesis.$$") || die "Could not create new file: $file.genesis.$$";
   while(<OLD>)
   {
        if (/$old/) {print NEW "$new\n";}
        else {print NEW $_;}
   }
   close(NEW);
   close(OLD);
   rename("$file.genesis.$$",$file) || die "Could not overwrite old file: $file";
}
 
                                                                                
sub open_files
{
 open (SH,">/etc/wireless.conf.sh"); # Voor firewall script. 
 open (NWCFG,">/etc/wl/nwcfg.sh"); # Voor network config
 open (DHCP,">/etc/dhcpd.conf") || die "Could not create dhcpd.conf";
 open (ZEBRA,">/etc/zebra/zebra.conf") || die "Could not create zebra.conf";
 open (OSPFD,">/etc/zebra/ospfd.conf") || die "Could not create ospfd.conf";
 open (MRTG,">/etc/mrtg/mrtg.cfg") || die "Could not create mrtg.cfg";
 open (RCCONF,">/etc/rc.conf") || die "Could not create rc.conf";
 open (FREEBSD,">/etc/rc.node.conf") || die "Could not create rc.node.conf";
 open (RESOLV,">/etc/resolv.conf") || die "Could not create resolv.conf";
 open (NAMED,">/etc/named.conf") || die "Could not create named.conf";
}


sub close_files
{
 close (SH);
 close (NWCFG);
 close (DHCP);
 close (ZEBRA);
 close (OSPFD);
 close (MRTG);
 close(RCCONF);
 close(FREEBSD);
 close(RESOLV);
 close(NAMED);
}

sub print_files
{
 print SH $sh;
 print NWCFG $nwcfg;
 print DHCP $dhcp;
 print ZEBRA $zebra;
 print OSPFD $ospfd;
 print MRTG $mrtg;
 print RCFONG $rcconf;
 print FREEBSD $freebsd;
 print RESOLV $resolv;
 print NAMED $named;
}


sub init_files
{
$sh=sprintf  <<EOSH;
#! /bin/bash
#
# Generated by $source
# on $now
#
$svn_version


gw_open=$gw_open
EOSH

$nwcfg=sprintf <<EONW;
#! /bin/bash
#
# Generated by $source
# on $now
#
#  DO NOT CHANGE!
#
# $author
# home: /etc/wl/nwcfg
#
$svn_version

EONW


$dhcp=sprintf <<EOD;
# dhcpd.conf
#
# Generated by $source
# on $now
#
#  $author
# home: /usr/local/etc/dhcpd.conf
#
$svn_version

option domain-name "$domain";

default-lease-time 7200;
max-lease-time 2592000;

ddns-update-style none;

# Hack for the WET11 
#
always-broadcast on;

EOD
#foreach $ns (split(/\s+/,$NS_forward)) 
#	{$dhcp.="option domain-name-servers ${ns};\n";}
	{$dhcp.="option domain-name-servers ${master_ip};\n";}

$dhcp.="\n\n";

$zebra= sprintf <<EOZ;
! -*- zebra -*-
!
! Zebra configuration for $hostname
!
! Generated by $source
! on $now
!
!  DO NOT CHANGE!
!
!   $author
!   home=/usr/local/etc/zebra/zebra.conf
!
$svn_version

hostname $hostname
password getronics
enable password getronics

! Interfaces

interface lo0
 description loopback                                                           
 ip address 127.0.0.1/8


EOZ

$ospfd=init_ospfd();

$mrtg=sprintf <<EOM;

#
# mrtg configuration for $hostname
#
# Generated by $source
# on $now
#
#  DO NOT CHANGE!
#
#   $author
#   home=/etc/mrtg
#
$svn_version

Workdir: /var/www/html/mrtg


#
#
#

Target[${hostname}_load]: `/usr/local/sbin/cpuload.pl`
MaxBytes[${hostname}_load]: 1000
Title[${hostname}_load]: CPU load on $hostname
PageTop[${hostname}_load]: <H1>CPU load on ${hostname}</H1>
Options[${hostname}_load]: transparent, gauge, nopercent 
Legendi[${hostname}_load]: 5min
Legendo[${hostname}_load]: 15min
ShortLegend[${hostname}_load]: %
YLegend[${hostname}_load]: %
WithPeak[${hostname}_load]: wmy

Target[${hostname}_mem]: `/usr/local/sbin/memusage.pl`
MaxBytes[${hostname}_mem]: 256000000
Title[${hostname}_mem]: Memory usage on ${hostname}
PageTop[${hostname}_mem]: <H1>Memory usage on ${hostname}</H1>
Options[${hostname}_mem]: transparent, gauge, nopercent 
Legendi[${hostname}_mem]: free
Legendo[${hostname}_mem]: swap
ShortLegend[${hostname}_mem]: Bytes
YLegend[${hostname}_mem]: Bytes
WithPeak[${hostname}_mem]: wmy

Target[${hostname}_up]: `/usr/local/sbin/uptime.pl`
MaxBytes[${hostname}_up]: 10000
Title[${hostname}_up]: ${hostname} Uptime
PageTop[${hostname}_up]: <H1>${hostname} Uptime</H1>
Options[${hostname}_up]: transparent, gauge, nopercent 
Legendi[${hostname}_up]: uptime
Legendo[${hostname}_up]: 
ShortLegend[${hostname}_up]: Days
YLegend[${hostname}_up]: Days
WithPeak[${hostname}_up]: wmy

EOM

$master_ip_on_alias="ifconfig_lo0_alias1=\"inet $master_ip/32\"";
foreach my $if (keys %config) {
  if( $IP{$if} =~ /([0-9\.]+).*/ ) {
    if( $1 eq $master_ip ) {
      $master_ip_on_alias="#ifconfig_lo0_alias1=\"inet $master_ip/32\"";
      break;
    };
  };
};


$rcconf.=sprintf <<EORC1;
# This file is read by /etc/rc.conf - and specific to wireless
# leiden. Please make all changes in Genesis.
#
# Generated by $source
# on $now
#
#  $author
#
$svn_version

hostname="$hostname.wLeiden.NET"
location="$location"

ifconfig_lo0_alias0="inet 172.31.255.1/32"
$master_ip_on_alias
EORC1

if ($tproxy !~ m/no/i) {
	$rcconf .= "# WARNING - specification propably wrong - check genesis. It should be a pure CIDR\n"
		unless $tproxy =~ m/\d+\.\d+\.\d+\.\d+\/\d+/;
	$rcconf .= "# Tproxy is ran on this system\n".
		"tproxy_enable='YES'\n".
		"tproxy_range='$tproxy'\n".
		"\n";
};

#$freebsd.=sprintf <<EOFB1;
# Wireless Leiden startup script om wireless kaarten te initialiseren
#
# Generated by $source
# on $now
#
#  $author
# home=/etc/wl/freebsd.sh
#
#$svn_version
#EOFB1

$resolv.=sprintf <<EOR1;
search wleiden.net .

# Local machine / own nameserver.
nameserver 127.0.0.1
EOR1

#foreach $ns (split(/\s+/,$NS_resolv)) {
#	$resolv.="nameserver $ns\n";
#}

foreach $if (sort keys %config) {
	foreach $ns (split(/[\s$separator]+/,$OSPF_NEIGHBORS{$if})) {
		next unless $ns =~  m/\d+/;
		$resolv.="# Nameserver on adjacent node - $DESC{$if} over $if\nnameserver $ns\n\n";
	};
};



$named.=sprintf <<EON1;
# named.conf
#
# Generated by $source
# on $now
#
#  $author
#  home=/etc/namedb/named.conf
#
$svn_version

options {
        directory "/var/db/namedb";
        forward only;
        forwarders {
		172.17.143.4;
		172.17.8.68;
		172.20.128.98;
//                   172.18.8.66;  // Internet GW Jasper
//		   172.17.32.66; // Internet GW Dirkx
EON1

%x=();
foreach $ns (split(/\s+/,$NS_forward)) {
	next if $ns eq $master_ip;
	$named.="                   ${ns};\n";
	$x{ $ns } = 1;
	}

foreach $if (sort keys %config) {
	foreach $ns (split(/[\s$separator]+/,$OSPF_NEIGHBORS{$if})) {
		next unless $ns =~  m/\d+/;
		$x{ $ns } = 0;
	};
};

#foreach(sort keys(%x)) {
#	next if $x{$_};
#	$named.="//                 $_; // Next door Neighbour..\n";
#	}

$named.=sprintf <<EON2;
	 };
};

zone "." {
        type hint;
        file "/etc/namedb/named.root";
};

zone "0.0.127.IN-ADDR.ARPA" {
        type master;
        file "/etc/namedb/localhost.rev";
};

zone "1.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.0.IP6.INT" {
        type master;
        file "/etc/namedb/localhost-v6.rev";
};

EON2

push (@ZONES,"wLeiden.NET");
for ($i=16;$i<32;$i++) {push(@ZONES,"$i.172.in-addr.arpa");}
foreach $zone (@ZONES)
{
 $named.=sprintf<<EON3;
zone "$zone" {
        type slave;
        file "slave-$zone";
        masters { 172.18.8.66; 212.61.66.38;};
};

EON3
}


$snmpd=<<EOM;
# /usr/local/share/snmp/snmpd.local.conf
# overwrites/augments the data in snmpd.conf
# which is identical on each node with data
# specific to this node.
#
#
#MIBS is not availible, commented by Rick van der Zwet
#mibs +LIGHT80211-MIB
EOM

$snmpd .= qq|
# Location of the physical node.
#
syslocation "$location"

|	if defined $location;

$snmpd .= qq|
# Location of the physical node.
#
syscontact "$contact"

|	if defined $contact;

$snmpd .= 
	"# Verify that disk is RO\n".
	"sh diskro /usr/local/sbin/diskro.sh\n\n"
	if ($DISK eq 'FLASH');

$snmpd.=<<EOM;

# Also listen to tcp
agentaddress 161,tcp:161
EOM

foreach my $if (keys %config) {
  if( $IP{$if} =~ /([0-9\.]+).*/ ) {
$snmpd.=<<EOM;
agentaddress $1
EOM
  };
};

$snmpd.=<<EOM;

# end of file 
EOM
}



sub init_ospfd
{
  
   local($init)=sprintf <<EOO;
! -*- ospfd -*-
!
! osfpd configuration for $hostname
!
! Configuration generated by $source
! on $now
!
!  DO NOT CHANGE!
!
!   $author
!   home=/usr/local/etc/zebra/ospfd.conf
!
$svn_version

hostname $hostname
password getronics
enable password getronics

interface lo0
EOO
  return($init);
}


sub mrtg1
{
$mrtg.=sprintf <<EOM2;
Target[${if}_traf]: `/usr/local/sbin/ipchains_traf.pl ${if}`
MaxBytes[${if}_traf]: $SPEED{$if}
Title[${if}_traf]: Traffic Analysis ${if} $SDESC{$if}
PageTop[${if}_traf]: <H1>Traffic on $if $DESC{$if}</H1>
Options[${if}_traf]: transparent
WithPeak[${if}_traf]: wmy                                                        

EOM2

if ($functions_only<1)
{
	ipchains("-N ${if}-i");
	ipchains("-N ${if}-o");
	ipchains("-I input -i ${if} -j ${if}-i");
	ipchains("-I output -i ${if} -j ${if}-o");

}
	if ($TYPE{$if}=~/wireless/i)
	{
	  $mrtg.=sprintf  <<EOM3;
Target[${if}_quality]: `/usr/local/sbin/wlan_quality.pl ${if}`
MaxBytes1[${if}_quality]: 100
MaxBytes2[${if}_quality]: 100
Title[${if}_quality]:  Quality $if $SDESC{$if}
PageTop[${if}_quality]: <H1>Quality $if $DESC{$if}</H1>
Options[${if}_quality]: transparent, gauge, nopercent
Legendi[${if}_quality]: Quality
Legendo[${if}_quality]: Noise
ShortLegend[${if}_quality]: /100
YLegend[${if}_quality]: /100
WithPeak[${if}_quality]: wmy                                                    

Target[${if}_rate]: `/usr/local/sbin/wlan_bitrate.pl ${if}`
MaxBytes1[${if}_rate]: 11
MaxBytes2[${if}_rate]: 11
Title[${if}_rate]: Bitrate $if $SDESC{$if}
PageTop[${if}_rate]: <H1>Bitrate $if $DESC{$if}</H1>
Options[${if}_rate]: transparent, gauge, nopercent
Legendi[${if}_rate]: Bitrate
ShortLegend[${if}_rate]: Mb/s
YLegend[${if}_rate]: Mb/s
WithPeak[${if}_rate]: wmy                                                      

EOM3
	  if ($MODE{$if}=~/master/i)
	  {
	  $mrtg.=sprintf  <<EOM4;
Target[${if}_users]: `/usr/local/sbin/wlan_users.pl ${if}`
MaxBytes[${if}_users]: 100
Title[${if}_users]: Users on $if $SDESC{$if}
PageTop[${if}_users]: <H1>Users on $if $DESC{$if}</H1>
Options[${if}_users]: transparent, gauge, nopercent
Legendi[${if}_users]: Users
ShortLegend[${if}_users]: users
YLegend[${if}_users]: users
WithPeak[${if}_users]: wmy                                                      

EOM4
	  }
	}  # wireless


}

sub mrtg2
{
$mrtg.=sprintf <<EOM5;
Target[${if}_lat]: `/usr/local/sbin/latency.pl $p`
MaxBytes1[${if}_lat]: 100
MaxBytes2[${if}_lat]: 200
Title[${if}_lat]: Latency/PktLoss Analysis to $p on $if $SDESC{$if}
PageTop[${if}_lat]: <H1>Latency/PktLoss to $p on $if $DESC{$if}</H1>
Options[${if}_lat]: transparent, gauge, nopercent
Legendi[${if}_lat]: PacketLoss%
Legendo[${if}_lat]: Max Latency (ms)
ShortLegend[${if}_lat]: %/ms
YLegend[${if}_lat]: %/ms
WithPeak[${if}_lat]: wmy
  
EOM5

}

sub ahum
{
  print "AHUM!\n";
}

#return(1);

