#!/usr/bin/perl
#
open STDIN,shift @ARGV
	or die "Cannot open $_:$!" 
		if @ARGV;

$domain = '.';

while(<STDIN>) {

	if (m/\$ORIGIN\s+([\w\-\.]+)/) {
		$domain = lc $1;
		next;
	};
	next 
		unless m/^\s*([\w\-\.]+)\s+(IN\s+)?A\s+([\d\.]+)/i;

	my ($host,$ip) = (lc $1,lc $3);

	$host .= '.'.$domain 
		unless $host =~ m/\.$/;

	warn "A-Resource defined in two places\n\tfor $ip/$host at line $. and $line{$ip}\n"
		if defined $host{$ip} and $host{$ip} eq $host;

	warn "A-Resource Conflict - there should be just one.\n\t$ip used for $host and $host{$ip} at line $. and $line{$ip}\n"
		if defined $host{$ip};

	warn "Resource defined in two places\n\t$host at $ip{$host} at line $. and $line{$host}.\n"
		if defined $ip{$host} and $ip eq $ip{$host};

	warn "Resource conflict - there should be just one.\n\t$host at $ip{$host} and $ip at line $. and $line{$host}\n"
		if defined $ip{$host};

	$host{$ip} = $host;
	$ip{$host} = $ip;
	$line{$ip} = $line{$host} = $.;

	print "$ip\t$host\n";
};

