#!/usr/bin/env python
# Generated by BigMap 2. Permalink: http://bigmap.osmz.ru/bigmap.php?xmin=33568&xmax=33599&ymin=21592&ymax=21615&zoom=16&scale=256&tiles=mapnik

import io, urllib2, datetime, time, re, random
from PIL import Image, ImageDraw
# ^^^^^^ install "python-pillow" package | pip install Pillow | easy_install Pillow

(zoom, xmin, ymin, xmax, ymax) = (16, 33568, 21592, 33599, 21615)
layers = ["http://tile.openstreetmap.org/!z/!x/!y.png"]
attribution = 'Map data (c) OpenStreetMap'
xsize = xmax - xmin + 1
ysize = ymax - ymin + 1

resultImage = Image.new("RGBA", (xsize * 256, ysize * 256), (0,0,0,0))
counter = 0
for x in range(xmin, xmax+1):
	for y in range(ymin, ymax+1):
		for layer in layers:
			url = layer.replace("!x", str(x)).replace("!y", str(y)).replace("!z", str(zoom))
			match = re.search("{([a-z0-9]+)}", url)
			if match:
				url = url.replace(match.group(0), random.choice(match.group(1)))
			print url, "... ";
			try:
				req = urllib2.Request(url, headers={'User-Agent': 'BigMap/2.0'})
				tile = urllib2.urlopen(req).read()
			except Exception, e:
				print "Error", e
				continue;
			image = Image.open(io.BytesIO(tile))
			resultImage.paste(image, ((x-xmin)*256, (y-ymin)*256), image.convert("RGBA"))
			counter += 1
			if counter == 10:
				time.sleep(2);
				counter = 0

draw = ImageDraw.Draw(resultImage)
draw.text((5, ysize*256-15), attribution, (0,0,0))
del draw

now = datetime.datetime.now()
outputFileName = "map%02d-%02d%02d%02d-%02d%02d.png" % (zoom, now.year % 100, now.month, now.day, now.hour, now.minute)
resultImage.save(outputFileName)
