#!/bin/sh



if echo $NANO_DRIVE | grep -q '^ufs/' then
	NANO_LABEL=`echo $NANO_DRIVE | cut -c 5-`

	# Detect GEOM drive to be updated based on the drive or label
	GEOM_DRIVE=`glabel status | grep ${NANO_DRIVE} | awk '{print $3}' | sed -e 's/s[0-9a]*$//g' | uniq`

	# Should never happen.
	if [ `echo $GEOM_DRIVE | wc -l` -gt 1 ] ; then
		echo "Bug: Multiple GEOM targets found with filter NANO_DRIVE=$NANO_DRIVE, unable to upgrade"
		glabel status | sed "s/^/Bug: /g"
		exit 1
	fi
else
	NANO_LABEL=""
	GEOM_DRIVE=$NANO_DRIVE
fi
