#!/bin/sh 
#
# CGI which process the request of the user _before_ he/she has pressed continue
#
# Rick van der Zwet <info@rickvanderzwet.nl>
#
PATH=$PATH:/usr/sbin:/usr/bin:/sbin
DB=/tmp/authenticated.txt
AUTOLOGIN_DB=/tmp/autologin.txt

REMOTE_MAC=`arp -n $REMOTE_ADDR | awk '{print $4}'`

# Make sure databases exists
touch $DB $AUTOLOGIN_DB

# Check user state
if grep -q $REMOTE_MAC $DB; then
  # User has already been here (ones) continue authention directly
  ./login/index.cgi
elif grep -q $REMOTE_MAC $AUTOLOGIN_DB; then
  # Device is marked as special, continue with autologin
  ./login/index.cgi
else
  echo 'HTTP 1.0 302 Found'
  echo ''
  # User is new, present welcome page
  sed -e "s/\$REMOTE_ADDR/$REMOTE_ADDR/" \
      -e "s/\$REMOTE_MAC/$REMOTE_MAC/" \
  	`dirname $0`/index.html.tmpl
fi
