## Building options
dumpdev="NO"			# No kernel dumps as we don't have a place to
				# store them 
ipv6_enable="NO"		# No IPv6 support for now, near feature... ;-)

# NTP server needs working config with WL network or internet on boot
# so some warnings might pop up, but no harm
ntpdate_enable="YES"
ntpd_enable="YES"
ntpd_sync_on_start="YES"
ntpd_flags="-p /var/run/ntpd.pid -f /var/db/ntp.drift"

# We need no running mail server
sendmail_enable="NONE"

# Don't let syslog accept input from other remote hosts
syslogd_enable="YES"
syslogd_flags="-s -A -c"

# Remote login without DNS checking as it might not also be functionable
# -u0 prevent sshd from making DNS requests unless the authentication mechanism
# or configuration requires it.
sshd_enable="YES"
sshd_flags="-u0"

# Don't update the motd as it not writeable, the update_nanobsd_motd is a
# simple wrapper found at /usr/local/etc/rc.d supporting this featureg
update_motd="NO"
update_nanobsd_motd="YES"

# Monitoring deamons
nrpe2_enable="YES"
snmpd_enable="YES"
snmpd_flags="-a -LF w /var/log/snmpd.log"

# HTTP(S) proxy server
tinyproxy_enable="YES"

# Make sure generated ssh keys are saved 
nanobsd_save_sshkeys_enable="YES"

## Port extentions
# Serve our clients some pretty cool IP address to at least get connected
# Also some low-memory footprint dns resolver
dnsmasq_enable="YES"

## WL ports extentions
thttpd_enable="YES"
http302_enable="YES"

# Make sure generated ssh keys are saved 
nanobsd_save_sshkeys_enable="YES"

#Hybrid
openvpn_enable="YES"
openvpn_if="tap"
cloned_interfaces="bridge0"
gateway_enable="YES"
pf_enable="YES"
pf_rules="/etc/pf.conf.ileiden"
pf_flags=""
pf2_enable="YES"
