#!/bin/sh
# $Id: fetchzone.sh 8637 2010-11-02 19:53:52Z richardvm $
#
# Wireless Leiden specific configuration to fetch DNS zones 
# used by MaraDNS
# 

# Updates of $ZONES we are going to fetch from the $SERVER every $IDLE seconds
ZONES="wleiden.net. 16.172.in-addr.arpa. 17.172.in-addr.arpa. 
18.172.in-addr.arpa. 19.172.in-addr.arpa. 20.172.in-addr.arpa.
21.172.in-addr.arpa. 22.172.in-addr.arpa. 23.172.in-addr.arpa.
24.172.in-addr.arpa. 25.172.in-addr.arpa. 26.172.in-addr.arpa.
27.172.in-addr.arpa. 28.172.in-addr.arpa. 29.172.in-addr.arpa.
30.172.in-addr.arpa. 31.172.in-addr.arpa."
SERVER=172.16.4.46
IDLE=3600

LOGFILE=/var/log/fetchzone.log
PIDFILE=/var/run/fetchzone.pid
### END OF USER CONFIGURABLE VARIABLES ###

# Create logging service
log() {
  echo `date "+%b %e %T"`":" $* >> ${LOGFILE}
}

# Register PID
PID=$$
echo ${PID} > ${PIDFILE}
log "[INFO] Fetchzone starting with PID: $PID"

# Make me a deamon script
while [ true ]; do 

  CHANGED_ZONES=""
  # Run through multiple zones
  for ZONE in ${ZONES}; do
    # (re) Set some extra vars
    TMPFILE=/tmp/dns-tmp-${ZONE}
    REALFILE=/usr/local/etc/maradns/db.${ZONE}
    # Execute Fetchzone
    /usr/local/bin/fetchzone ${ZONE} ${SERVER} > ${TMPFILE}
  
    # Did Fetchzone exit unhappy
    if [ $? -ne 0 ]; then
      # Something went wrong lets log it
      log "[ERROR] [$ZONE] Errors found in fetchzone query"
      continue
    fi

    # Are there any changes, we need to put active?
    diff -q  ${TMPFILE} ${REALFILE}
    if [ $? -ne 0 ]; then
      log "[INFO] [$ZONE] Changes found"
      cp ${TMPFILE} ${REALFILE}
      CHANGED_ZONES="$CHANGED_ZONES $ZONE"
    fi
  done

  # Maradns requires a restart to load new zonefile
  if [ -n "$CHANGED_ZONES" ]; then
    log "[INFO] `/usr/local/etc/rc.d/maradns restart`"
  fi

  # Next run in $IDLE seconds
  sleep ${IDLE}
done

