#!/bin/sh
#
# Simple deamon which does remote connecting to a sertain host for tunnel
# forwarding.
#
# !!WARNING!!!!!!!!!!WARNING!!!!!!!!!!!WARNING!!!!!!!!!!WARNING!!!!!!!!!! 
# !!                                                                   !!
# !!  THIS IS A HACK AND REQUIRES INTERACTIVE LOGIN ON THE REMOTE SIDE !! 
# !!  MAKE SURE TO LIMIT AND SECURE YOUR SETUP IN ANY WAYS YOU CAN     !!
# !!  INCLUDING BUT NOT LIMITED TO FIREWALL RULES, PROPER LOGGING,     !!
# !!                                                                   !!
# !!  MAKE SURE TO SURE YOUR PUBLIC SSH KEY TO AVOID HARM BY USING:    !!
# !!    from="example.org",no-user-rc,no-X11-forwarding,no-pty,        !!
# !!    no-agent-forwarding,command="",permitopen="127.0.0.1:1"        !!
# !!                                                                   !!
# !!WARNING!!!!!!!!!!WARNING!!!!!!!!!!!WARNING!!!!!!!!!!WARNING!!!!!!!!!! 
#
# Licence: BSDLike - https://www.wirelessleiden.nl/LICENSE 
#
# Created by Richard van Mansom - Jan 2010
# Make daemon friendly by Rick van der Zwet  - Feb 2010
# Revamp to secure and reuse in multiple setups Rick van der Zwet - Oct 2010

PWD=`dirname $0`

# User variables
SSH_HOST=${SSH_HOST:-sshtun.wirelessleiden.nl}
SSH_USER=${SSH_USER:-ssh-tun}
SSH_KEY=${SSH_KEY:-${PWD}/sshkey}

PIDFILE=${PIDFILE:-/var/run/sshtun.pid}
LOGFILE=${LOGFILE:-/var/log/sshtun.log}

RECONNECT_TIMEOUT=${RECONNECT_TIMEOUT:-`expr 60 \* 5`}

log() {
  echo `date "+%b %e %T"` ": " $* >> ${LOGFILE}
}

# Internal helpers, storage and shortcuts
SSH_PID=""

# On (forced) exit, close tunnel and make sure to cleanup the leftovers.
trap_exit() {
   SIGNAL=$1
   log "Received signal '$SIGNAL'"
   if [ -n "$SSH_PID" ]; then
     kill $SSH_PID
   fi
   rm -f $PIDFILE
   exit $SIGNAL
}

# Don't leave the ssh client process behind and exit with proper exit code
for SIGNAL in 1 2 15; do
  trap "trap_exit $SIGNAL" $SIGNAL
done


# Make sure a port is specified
SSH_FLAGS=$@
if [ -z "$SSH_FLAGS" ]; then
  echo "Usage: $0 <SSH_CLIENT_FLAGS>"
  echo ""
  echo "Example: $0 -R 127.0.0.1:10022:127.0.0.1:22"
  exit 64
fi

# Store script PID in right location
echo $$ > $PIDFILE || exit 1

log "[INFO] Connecting with args: $SSH_FLAGS"

# Make sure the tunnel keeps on reconnecting
while true
do
  # Connect to remote site
  COMMAND="ssh ${SSH_FLAGS} -i ${SSH_KEY} ${SSH_USER}@${SSH_HOST} -o ServerAliveInterval=5 \
    -o ExitOnForwardFailure=yes -o BatchMode=yes  -o StrictHostKeyChecking=no \
    -n -N" 
  log "[INFO] Connect using $COMMAND"
  $COMMAND 1>&2 2>> $LOGFILE &

  # Save the sshtun PID
  SSH_PID=$!
  log "[NOTICE] Used PID: $SSH_PID"

  # As long the client is running make sure to sleep and relax
  wait 

  # Mark process disconnected
  log "[NOTICE] SSHTUN Disconnected ${SSH_PID}"
  SSH_PID=""

  log "[INFO] Sleeping $RECONNECT_TIMEOUT seconds before reconnect"
  SECONDS=$RECONNECT_TIMEOUT
  # Nasty hack to avoid shell from ignoring signals while sleeping a long time
  while [ $SECONDS -ge 0 ]; do
    sleep 5
    SECONDS=`expr $SECONDS - 5`
  done

done

log "[ERROR] Should never be able to get here"
trap_exit

