#!/bin/sh
# Simple deamon which does remote connecting to a sertain host for tunnel
# forwarding.
#
# !!WARNING!!!!!!!!!!WARNING!!!!!!!!!!!WARNING!!!!!!!!!!WARNING!!!!!!!!!! 
# !!                                                                   !!
# !!  THIS IS A HACK AND REQUIRES INTERACTIVE LOGIN ON THE REMOTE SIDE !! 
# !!  CANNOT BE USED WITHOUT ANY OTHER PROPER SECURITY MEASURES LIKE   !!
# !!  BUT LIMITED TO IP BLOCKING/USER LIMITED ACCESS AND PROPER LOGS.  !!
# !!                                                                   !!
# !!WARNING!!!!!!!!!!WARNING!!!!!!!!!!!WARNING!!!!!!!!!!WARNING!!!!!!!!!! 
#
# Created by Richard van Mansom - Jan 2010
# Make deamon friendly by Rick van der Zwet  - Feb 2010


# Define some vars
PWD=`dirname $0`
SSH_FLAGS=$@

HOST="sshtun.wirelessleiden.nl"
USER="ssh-tun"
SSHKEY="${PWD}/sshkey"
PID='/var/run/sshtun.pid'
LOGFILE='/var/log/sshtun.log'

# Program internal variables
WAIT="600"
REMOTEWAIT=`expr 3600 \* 24 \* 365`

log() {
  echo `date "+%b %e %T"` ": " $* >> ${LOGFILE}
}

# Store script PID in right location
echo $$ > $PID || exit 1

SSHPIDFILE=`mktemp -t $(basename $0)`

trap_exit() {
   if [ -s $SSHPID ]; then
     kill `cat $SSHPID`
     rm $SSHPID
   fi
   exit
}

# Don't leave the ssh client process behind
trap "trap_exit" 0 1 2 15

# Make sure a port is specified
if [ -z "$SSH_FLAGS" ]; then
  echo "Usage: $0 <SSH_CLIENT_FLAGS>"
  exit 64
fi

# Main program
log "[INFO] Connecting with args: $SSH_FLAGS"

# Make sure the tunnel keeps on reconnecting
while true
do
  # Connect to remote site
  ssh ${SSH_FLAGS} -i ${SSHKEY} ${USER}@${HOST} -o ServerAliveInterval=5 \
    -o ExitOnForwardFailure=yes -o BatchMode=yes  -o StrictHostKeyChecking=no \
    -n -N "sh -c 'sleep ${REMOTEWAIT}'" &

  # Save the sshtun PID
  SSHPID=$!
  echo ${SSHPID} > ${SSHPIDFILE}
  log "[NOTICE] Used PID: $SSHPID"

  # As long the client is running make sure to sleep and relax, don't make it very
  # long as a sleeping shell script cannot receive sigtals
  while [ `ps ax | awk '{ print $1 }' | grep "^$SSHPID\$"` ]; do
     sleep 10
  done
  log "[NOTICE] SSHTUN Disconnected ${SSHPID}"

  # Mark process disconnected
  echo "" > ${SSHPIDFILE}

  log "[INFO] Sleeping $WAIT seconds before reconnect"
  sleep ${WAIT}
done

