#!/bin/sh -
# Based on /etc/rc.firewall

allowed2internet="80,443"
maxconnections="10"

# Suck in the configuration variables.
if [ -z "${source_rc_confs_defined}" ]; then
	if [ -r /etc/defaults/rc.conf ]; then
		. /etc/defaults/rc.conf
		source_rc_confs
	elif [ -r /etc/rc.conf ]; then
		. /etc/rc.conf
	fi
fi

setup_loopback () {
	############
	# Only in rare cases do you want to change these rules
	#
	${fwcmd} add 100 pass all from any to any via lo0
	${fwcmd} add 200 deny all from any to 127.0.0.0/8
	${fwcmd} add 300 deny ip from 127.0.0.0/8 to any
}

############
# Set quiet mode if requested
#
case ${firewall_quiet} in
[Yy][Ee][Ss])
	fwcmd="/sbin/ipfw -q"
	;;
*)
	fwcmd="/sbin/ipfw"
	;;
esac

###########
# Set Internal/External Interface
#
driver=`echo ${internalif} | sed 's/[0-9]*//g'`
seq=`echo ${internalif} | sed 's/[a-zA-Z]*//g'`

if [ ${seq} = 0 ]; then
  seq=`expr ${seq} \+ 1`
else
  seq=`expr ${seq} \- 1`
fi

externalif="$driver$seq"

# Get public ip
externalip=`ifconfig $externalif | awk '/inet/ { print $2 }'`
############
# Flush out the list before we begin.
#
${fwcmd} -f flush

setup_loopback


############
# Block the hosters network (and maybe others)

for IP in ${firewall_block}
do
  ${fwcmd} add deny ip from any to ${IP} in via $internalif
done

#############
# Outbound NAT setup

${fwcmd} add nat 100 all from 172.16.0.0/12 to any out via $externalif
${fwcmd} add nat 100 all from any to $externalip in via $externalif
${fwcmd} nat 100 config if $externalif

#############
# WL -> Internet
# Stateful firewalling

${fwcmd} add 3000 check-state
# HTTP
${fwcmd} add 3001 allow tcp from 172.16.0.0/12 to any $allowed2internet in via $internalif setup limit src-addr $maxconnections
# HTTPS

# Allow anything originating from me
${fwcmd} add 4001 allow ip from me to any keep-state

# Allow on any interface
# Allow SSH
${fwcmd} add 5001 allow tcp from any to me 22 keep-state

# Allow on internal interface
# DNS
${fwcmd} add 6001 allow ip from any to me 53 via $internalif keep-state

# NTP
${fwcmd} add 6002 allow udp from any to me 123 via $internalif keep-state

# HTTP-PROXY
${fwcmd} add 6003 allow tcp from any to me 3128 via $internalif keep-state

# lvrouted
${fwcmd} add 6004 allow udp from 172.16.0.0/12 to me 12345 via $internalif keep-state

# Block anything else
${fwcmd} add 65000 deny ip from any to any

