#!/bin/sh -
# Based on /etc/rc.firewall

# Suck in the configuration variables.
if [ -z "${source_rc_confs_defined}" ]; then
        if [ -r /etc/defaults/rc.conf ]; then
                . /etc/defaults/rc.conf
                source_rc_confs
        elif [ -r /etc/rc.conf ]; then
                . /etc/rc.conf
        fi
fi

setup_loopback () {
        ############
        # Only in rare cases do you want to change these rules
        #
        ${fwcmd} add 100 pass all from any to any via lo0
        ${fwcmd} add 200 deny all from any to 127.0.0.0/8
        ${fwcmd} add 300 deny ip from 127.0.0.0/8 to any
}

############
# Set quiet mode if requested
#
case ${firewall_quiet} in
[Yy][Ee][Ss])
        fwcmd="/sbin/ipfw -q"
        ;;
*)
        fwcmd="/sbin/ipfw"
        ;;
esac

###########
# Set Internal/External Interface
#
driver=`echo ${internalif} | sed 's/[0-9]*//g'`
seq=`echo ${internalif} | sed 's/[a-zA-Z]*//g'`

if [ ${seq} = 0 ]; then
  seq=`expr ${seq} \+ 1`
else
  seq=`expr ${seq} \- 1`
fi

externalif="$driver$seq"

# Get public ip
$externalip=`ifconfig $externalif | awk '/inet/ { print $2 }'`
############
# Flush out the list before we begin.
#
${fwcmd} -f flush

setup_loopback


############

#############
# Outbound NAT setup
${fwcmd} add nat 100 all from 172.16.0.0/12 to any via $externalif
${fwcmd} add nat 100 all from any to 192.168.58.2 via $externalif
${fwcmd} nat 100 config if $externalif

############
# Inbound NAT setup
# ${fwcmd} add nat 200 all from any to 172.16.0.0/12 via $internalif
# ${fwcmd} nat 200 config if $internalif

# WL -> Internet
# Stateful firewalling
${fwcmd} add 3000 check-state
# HTTP
${fwcmd} add 3001 allow tcp from 172.16.0.0/12 to any 80 in via $internalif setup keep-state
# HTTPS
${fwcmd} add 3002 allow tcp from 172.16.0.0/12 to any 443 in via $internalif setup keep-state

# Allow anything originating from me
${fwcmd} add 4001 allow ip from me to any

# Allow on any interface
# Allow SSH
${fwcmd} add 5001 allow tcp from any to me 22

# Allow on internal interface
# DNS
${fwcmd} add 6001 allow ip from any to me 53 via $internalif

# NTP
${fwcmd} add 6002 allow udp from any to me 123 via $internalif


