#!/bin/sh

# Set some vars
ZONES="wleiden.net 16.172.in-addr.arpa. 17.172.in-addr.arpa. 
18.172.in-addr.arpa. 19.172.in-addr.arpa. 20.172.in-addr.arpa.
21.172.in-addr.arpa. 22.172.in-addr.arpa. 23.172.in-addr.arpa.
24.172.in-addr.arpa. 25.172.in-addr.arpa. 26.172.in-addr.arpa.
27.172.in-addr.arpa. 28.172.in-addr.arpa. 29.172.in-addr.arpa.
30.172.in-addr.arpa. 31.172.in-addr.arpa."

SERVER=195.169.86.131
APP=/usr/local/bin/fetchzone
LOGFILE=/var/log/fetchzone.log
PIDFILE=/var/run/fetchzone.pid
IDLE=3600

# Create logging service
log() {
  echo `date "+%b %e %T"`":" $* >> ${LOGFILE}
}

# Register PID
PID=$$
echo ${PID} > ${PIDFILE}

# Tell logfile that I am starting
log "[INFO] Fetchzone starting with PID: $PID"

# Make sure I never die
while [ true ]; do 

  # Run through multiple zones
  for ZONE in ${ZONES}
  do

    # (re) Set some extra vars
    TMPFILE=/tmp/dns-${ZONE}.tmp
    REALFILE=/usr/local/etc/maradns/db.${ZONE}
    # Execute Fetchzone
    ${APP} ${ZONE} ${SERVER} > ${TMPFILE}
  
    # Did Fetchzone exit unhappy
    if [ $? -eq 0 ]; then
  
      # Are there any changes?
      COMM=`comm -23 ${TMPFILE} ${REALFILE} 2>&1`
      if [ -n "$COMM" ]; then
  
        # If there are any changes copy tmp to realfile
        log "[INFO] Changes found"
        cp ${TMPFILE} ${REALFILE}
  
        # Maradns requires a restart to load new zonefile
        /usr/local/etc/rc.d/maradns restart
  
      fi
    else
  
      # Something went wrong lets log it
      log "[ERROR] Errors found in fetchzone query"
    fi

  done

  # Lets go to sleep
  sleep ${IDLE}
done

