#!/bin/sh
# Wrapper allowing to write image to card writer

. $(dirname $0)/package-build.inc.sh

BASEDIR=`dirname $0`
if [ -n "$1" ]; then
  IMG=$1
else
  CFG="${BASEDIR}/../cfg/nanobsd.wleiden"
  
  # Find object directory 
  eval `grep '^NANO_NAME=' ${CFG}`
  OBJDIR="/usr/obj/nanobsd.${NANO_NAME}"
  IMG=${OBJDIR}/_.disk.full
fi

if [ ! -r "${IMG}" ]; then
  p_err Source ${IMG} does not exists
fi
IMGSIZE=`ls -l ${IMG} | awk '{print $5 / 1024 / 1024}'`

# Make sure we are root from this point on
f_check_root

# Find which daX device holds a active flash drive
CARD_FOUND=0
DA_LIST=`cd /dev/; echo da[0-9]`
for DA in ${DA_LIST}; do
 diskinfo ${DA} 1>/dev/null 2>/dev/null
 if [ $? -eq 0 ]; then
   CARD_FOUND=1
   break
 fi
done

if [ ${CARD_FOUND} -eq 0 ]; then
  p_err Sorry no flash card found at active devices, list searched:
  p_err $(p_list ${DA_LIST})
  exit 1
fi

# Detect cardreader type/version
CARDREADER=`dmesg | grep ${DA}: | awk -F'[<>]' '/Removable Direct Access/ {print $2}' | tail -1`

#XXX: Issue last chance warning, prompting the user to bail out
p_warn Going to write ${IMG} "(${IMGSIZE}MB)" to ${DA} "(${CARDREADER})"
p_warn 5 seconds to quit using CTRL+C
p_sleep 5

TMPFILE=`mktemp -t dd`
p_info Writing image... "(`date`)"
dd if=${IMG} of=/dev/${DA} bs=64k 2>${TMPFILE} &
DD_PID=$!
while `ps ${DD_PID} >/dev/null`; do
  kill -INFO ${DD_PID}
  sleep 1 #Micro delay allow TMPFILE to populate
  SIZE_DONE=`awk '/transferred/ {print $1}' ${TMPFILE}`
  SIZE_DONE=`echo "${SIZE_DONE} / 1024 / 1024" | bc -l`
  PERCENT_DONE=`echo "${SIZE_DONE} / ${IMGSIZE} * 100"  | bc -l`
  p_info `date "+%H:%m:%S"` `printf "%.02f MB (%.01f%%)" ${SIZE_DONE} ${PERCENT_DONE}`
  p_sleep 10
  : > ${TMPFILE}
done
rm ${TMPFILE}
p_info Image writing succesfull at /dev/$DA "(`date`)"
