#!/bin/sh

NAME=`hostname -s`

RULES=`/usr/local/bin/curl http://dense.wirelessleiden.nl/dense/results.php/proxy/${NAME}`

OUTPUTFILE="/tmp/dense-results.txt"

BIN="/usr/local/sbin/send_nsca"
CONFIG="/usr/local/etc/nagios/send_nsca.cfg"
HOST="127.0.0.1"

/bin/echo "" > ${OUTPUTFILE}

/bin/echo "$RULES" | awk -F";" '{
  check="/usr/local/libexec/nagios/" $5;
  check="OUTPUT=`" check "`; EXIT=$?; echo \"$EXIT\t$OUTPUT\"";
  check | getline output
  print $2 "\t" $4 "\t" output;
  close(check);
}' >> ${OUTPUTFILE}

${BIN} -c ${CONFIG} -H ${HOST} < ${OUTPUTFILE}

