#!/bin/sh
# Install all required packages
# XXX: Welcome to port hell, if /usr/ports has been updated, you actually want
# to delete all installed packages and start over again, hence why people used
# to run this stuff in jails, etc.

. $(dirname $0)/package-build.inc.sh

DEBUG=${DEBUG:-0}
DEP_CHECK_ONLY=${DEP_CHECK_ONLY:-0}

# make options, for package building
LOGDIR=`mktemp -d "/tmp/$(basename $0 .sh)-$(date +%Y%m%d-%H:%M:%S).X"`
TARGET="`cd $(dirname $0);pwd -P`/../pkg/"

# Package target
MAKE_ARGS="$MAKE_ARGS PACKAGES=$TARGET"
MAKE_ARGS="$MAKE_ARGS BATCH=yes PACKAGE_BUILDING=yes"

# www/py-cherrypy
MAKE_ARGS="${MAKE_ARGS} WITH_APACHE=no"
# net-mgmt/net-snmp
MAKE_ARGS="${MAKE_ARGS} WITHOUT_PERL=yes"
# net-mgmt/nagios-plugins
MAKE_ARGS="${MAKE_ARGS} WITH_FPING=yes"
MAKE_ARGS="${MAKE_ARGS} WITH_NETSNMP=yes"

p_info Log directory ${LOGDIR}
p_info Make options are:
p_info $(p_list ${MAKE_ARGS})

p_info Checking whether there are currently unmet dependencies
RETVAL=0
PKGS=`pkg_info | awk '{print $1}'`
for PKG in ${PKGS} ; do
  PKG_DEP_FAIL=""
  for PKGDEP in `pkg_info -qr ${PKG} | awk '{print $2}'`; do
    pkg_info -e ${PKGDEP} 
    if [ $? -eq 1 ]; then
      PKG_DEP_FAIL="${PKG_DEP_FAIL} ${PKGDEP}"
    fi
  done
  if [ -n "${PKG_DEP_FAIL}" ]; then
      p_err Unmet dependencies found at $PKG, please fix manually:
      p_err $(p_list ${PKG_DEP_FAIL})
      RETVAL=1
  fi
done
if [ $RETVAL -eq 1 ]; then
  exit 1
fi
p_info Dependecy check ok

if [ ${DEP_CHECK_ONLY} -eq 1 ]; then
  exit 0
fi
echo ""


if [ -d "${TARGET}/All" ]; then
	p_warn "Deleted all (old) packages at ${TARGET}"
	rm -R $TARGET/*
fi
p_info Created target dir ${TARGET}/All
mkdir -p ${TARGET}/All

PORTSDIR='/usr/ports'
WL_PORTSDIR="`cd $(dirname $0);pwd -P`/../misc/ports/"

# XXX: Make file dynamic
# Dirty quirk to allow comments in part below
PACKAGE_LIST=`cat <<EOF | sed 's/#.*$//g'
$PORTSDIR/dns/nsd
$PORTSDIR/www/tinyproxy
$PORTSDIR/editors/vim-lite
$PORTSDIR/security/nmap
$PORTSDIR/net-mgmt/net-snmp
$PORTSDIR/net-mgmt/nrpe2
# $PORTSDIR/net-mgmt/nagios-snmp-plugins-extras
# $PORTSDIR/net-mgmt/nagios-snmp-plugins
$PORTSDIR/benchmarks/iperf
$PORTSDIR/net-mgmt/nsca-client
$PORTSDIR/ftp/curl
$PORTSDIR/net/rsync

# Wireless Leiden ports at $WL_PORTSDIR
# $WL_PORTSDIR/net/lvrouted
# $WL_PORTSDIR/net/transproxy
`

MAKE="make ${MAKE_ARGS}"

BUILD_LIST=''
# Build required packages
set ${PACKAGE_LIST}
while [ "$1" ]; do
  PACKAGE=$1; shift
  BUILD_LIST="${BUILD_LIST} ${PACKAGE}"

  # Build new one
  LOGFILE="$LOGDIR/build$(echo $PACKAGE | tr '/' '_').log"
  echo ""
  p_info Packaging $PACKAGE
  cd ${PACKAGE}

  
  # Check for build dependencies
  BUILDDEP_PKG=`${MAKE} build-depends-list | awk -F: '{print $2}'`
  if [ -n "${BUILDDEP_PKG}" ]; then
	  p_info Build dependencies needed are:
          p_info $(p_list ${BUILDDEP_PKG})
  fi

  # Check for run dependencies
  PKGDEP_PKGS=`${MAKE} package-depends-list | awk '{print $2}'`
  if [ -n "${PKGDEP_PKGS}" ]; then
	  p_info Package dependencies also packaged are:
	  p_info $(p_list ${PKGDEP_PKGS})
  fi

  # Check if package is already installed
  VERSION=`${MAKE} clean generate-plist check-already-installed | awk '/is already/ {print $2}'`
   if [ -n "${VERSION}" ]; then
     VERSION=`echo ${VERSION} | sed 's/^.*-//g'`
     p_info ${PACKAGE} already installed at ${VERSION}
     MAKE_OPTION=''
   elif [ "${VERSION}" = "An" ]; then
     #XXX: Better way to detect whether a package needs updating
     # An older version of lang/python26 is already installed (python26-2.6.2)
     p_warn ${PACKAGE} outdated, updating...
     p_warn re-run package-build.sh to check for unmet ones done using:
     p_warn $0
     MAKE_OPTION='deinstall reinstall'
   else
     p_info ${PACKAGE} not installed, installing...
     MAKE_OPTION='install'
   fi

  if [ -n "${MAKE_OPTION}" ]; then
    p_info Buildlog: $LOGFILE
    ${MAKE} ${MAKE_OPTION} 2>>$LOGFILE 1>> $LOGFILE
    if [ $? -ne 0 ]; then
       p_err building ${PACKAGE} FAILED, logging at $LOGFILE
       exit 1
    fi
  fi
  ${MAKE} package-links
  PKGNAME=`make extract-message | awk '{print $NF}'`
  pkg_create -b $PKGNAME $TARGET/All/${PKGNAME}.tbz

  p_info Checking dependencies
  for PKG in $PKGDEP_PKGS; do
     echo "${BUILD_LIST}" | grep -q "$PKG"
     if [ $? -eq 0 ]; then
       # Already packaged
       p_info ${PKG} Already packaged
     else
       echo $@  | grep -q "${PKG}"
       if [ $? -eq 0 ]; then
          p_info ${PKG} Already planned
       else
          set $@ ${PKG}
       fi
     fi
  done
  p_info Packaging $PACKAGE succesfull
done
  
p_info $(echo ${BUILD_LIST} | wc -w) packages build succesfully

if [ ${DEBUG} -eq 0 ]; then
  rm -R ${LOGDIR}
else
  p_info Debugging enabled ${LOGDIR} saved
fi

