#!/bin/sh

# Define some vars
DIR=`dirname $0`
CMD=$1
HOST="dellas.wirelessleiden.nl"
REMOTEPORT=$2
LOCALPORT="22"
USER="ssh-tun"
SSHKEY="${DIR}/sshkey"
WAIT="10" 
REMOTEWAIT=`expr 3600 \* 24 \* 365`
echo ${REMOTEPORT}

# Make sure a port is specified
if [ -n "$REMOTEPORT" ]; then

  case $1 in
    start) 
  
      PROCESS=`ps -ax | grep localhost | grep sshtun | grep ${REMOTEPORT} | grep -v grep | awk '{print $1}'`
      if [ -z "$PROCESS" ]; then
  
        sleep 1

        echo "Connecting using port $REMOTEPORT"
  
        # Make sure the script never dies
        while [ true ]
        do
        
          # Connect to remote site
          ssh -R ${REMOTEPORT}:localhost:${LOCALPORT} -i ${SSHKEY} ${USER}@${HOST} -o ServerAliveInterval=5 -o ExitOnForwardFailure=yes "sh -c 'sleep ${REMOTEWAIT}'"
        
          # Echo some stuff
          date
          echo "Sleeping $WAIT seconds"
          echo ""
        
          # Go to sleep 
          sleep ${WAIT}
        done
  
      else
        echo "Tunnel already running"
        echo "Pid: "
        echo ${PROCESS}
      fi
  
    ;;
    stop)
  
      # Killing the tunnel
      PROCESS=`ps -ax | grep -v stop | grep -E '(ssh-tun|sshtun)' | grep ${REMOTEPORT} | grep -v grep | awk '{print $1}'`
  
      if [ -n "$PROCESS"  ]; then
        echo "Killing session with port $REMOTEPORT :
  $PROCESS"
        echo ${PROCESS} | xargs kill -9
      fi
    ;;
  
    *)
      # Display usage info
      echo "Usage: ./sshtun <ACTION> <PORT>"
    ;;
  esac
fi
