#!/bin/sh
#
# Add the following line to /etc/rc.conf to enable ssh-tun:
#
# sshtun_enable="YES"
# 
# PROVIDE: sshtun
# REQUIRE: LOGIN 

. /etc/rc.subr

name=sshtun
rcvar=`set_rcvar`

port=${sshtun_port}

command=/usr/local/sshtun/sshtun.sh

pidfile=/var/run/${name}.pid

load_rc_config ${name}

sshtun_enable=${sshtun_enable-"NO"}

stop_cmd="sshtun_stop"
start_cmd="sshtun_start"

sshtun_start()
{
  ${command} start ${port} &
}

sshtun_stop()
{
  ${command} stop ${port}
}


run_rc_command "$1"


