#!/bin/sh -
# Based on /etc/rc.firewall

# Suck in the configuration variables.
if [ -z "${source_rc_confs_defined}" ]; then
	if [ -r /etc/defaults/rc.conf ]; then
		. /etc/defaults/rc.conf
		source_rc_confs
	elif [ -r /etc/rc.conf ]; then
		. /etc/rc.conf
	fi
fi

setup_loopback () {
	############
	# Only in rare cases do you want to change these rules
	#
	${fwcmd} add 100 pass all from any to any via lo0
	${fwcmd} add 200 deny all from any to 127.0.0.0/8
	${fwcmd} add 300 deny ip from 127.0.0.0/8 to any
}

############
# Set quiet mode if requested
#
case ${firewall_quiet} in
[Yy][Ee][Ss])
	fwcmd="/sbin/ipfw -q"
	;;
*)
	fwcmd="/sbin/ipfw"
	;;
esac

############
# Flush out the list before we begin.
#
${fwcmd} -f flush

setup_loopback

############

# By default no firewalling
${fwcmd} add 65000 pass all from any to any

# Transproxy/WLportal/Captive portal
${fwcmd} add 10000 allow tcp from any to localhost 80
${fwcmd} add 10001 allow tcp from any to me 80

############
# Reserved: WLPortal rule numbers
# 10010 - 10099

# Forward rules work without a base address, so needed a loop over all inet4 adresses
for IP in `ifconfig -a | awk '/inet / {print $2}'`; do
  ${fwcmd} add 10100 fwd $IP,8081 tcp from any to not 172.16.0.0/12 80
done
