#!/usr/bin/env python
#
# Bouw een template Wireless Leiden wleiden.conf voor een nieuwe node
# Rick van der Zwet <info@rickvanderzwet.nl>
import getrange
import sys

__version__ = '$Id$'

if len(sys.argv) <> 2:
    print "Gebruik %s <nodeNaam>" % sys.argv[0]
    print "Configurator versie: %s" % __version__
    exit(1)

nodename = sys.argv[1]
# ALIX/IRIS Boord standaard interfaces
interfaces = "vr0 vr1 vr2 ue0 ue1".split(' ')

# Initieele IP interface, aannemend dat alles master is
master_ip = getrange.get_ranges(False, 24, 1)[0] + 1
interlinks = getrange.get_ranges(True, 29, len(interfaces))

# Maak de boel een beetje standaard
variables = {
        'nodename' : nodename[0].upper() + nodename[1:],
        'nodename_lower' : nodename.lower(),
        'master_ip' : getrange.showaddr(master_ip),
        'version' : __version__ }

# Header
print """
#
# Configuratie voor CNode%(nodename)s
# Configuratie gegenereerd met configurator versie %(version)s
#
$location="Locatie XXX, Straat XXX, XXXX XX, Leiden";
$master_ip='%(master_ip)s';  
$nodetype='CNode';
$nodename='%(nodename)s';
$status='up';
$release="8.0-RELEASE";
$X='XXXXX';
$Y='XXXXXX';
$LON='4.XXX';
$LAT='52.XXX';
""" % variables

# Accesspoint
print """
$config{'ath0'}=sprintf <<ATH0;  # Access point Buurt
TYPE=wireless
IP=%(master_ip)s/26
DESC=AP
SDESC=ap
DHCP=10-60
MODE=master
ESSID=ap-WirelessLeiden-%(nodename)s
CHANNEL=8
ATH0
""" % variables

# Alle interfaces
for index, ifname in enumerate(interfaces):
    print """
$config{'%(ifname)s'}=sprintf <<%(ifname_caps)s;  # Link naar XXX
TYPE=ethernet
EXTRA_TYPE=eth2wifibridge
IP=%(ip)s/29
DESC=Link naar XXX
SDESC=2xxx-%(ifname)s
#MODE=XXX
#ESSID=XX-XX.%(nodename_lower)s.wleiden.net
#CHANNEL=XX
#NSMAC=
#NS_IP=%(ns_ip)s/29
DHCP=no
%(ifname_caps)s
""" % { 'nodename_lower' : nodename.lower(),
        'ifname' : ifname,
        'ifname_caps' : ifname.upper(),
        'ip' : getrange.showaddr(interlinks[index] + 1),
        'ns_ip' : getrange.showaddr(interlinks[index] + 2) }

