#!/usr/bin/env perl

#maak een mooi systeem met hash aanroepen om snel gegevens te verwerken
sub parse_config {
  foreach my $id (sort keys %config) {
    my $rawData = $config{$id};
    $rawData =~ s/#.*\n/\n/g;                  #wegslopen comments
    $rawData =~ s/\s*[\r,\n]+\s*/:::/g;        #spaties+enter+spaties vervangen door :::
    $rawData =~ s/^::://;                      #::: aan het begin weghalen
    $rawData =~ s/:::$//;                      #::: aan het eind weghalen
    my @configArray = split( /:::/, $rawData); #array er van maken
    foreach $line (@configArray) {
      (my $name, my $value) = split( /\=/, $line);
      $$name{$id} = $value;
    };
  };
}; #end parse_config

sub clean_ip {
    local($ip,$name) = @_;
    split('/',$ip);
    print "@_[0]|$name\n";

};

  #ga alle config files doorwerken
  foreach my $file (`ls -1`) {
    chomp($file);
    $file .= "/wleiden.conf";
    if (not ($file =~ /^CNode/ or $file =~ /^proxy/)) {
    }
    else {
        print STDERR  "Working on $file...\n";
        #clean up all old variablen
          @$_ = [] foreach qw(static_dhcp);
          $$_ = "" foreach qw(location master_ip gw_open nodetype nodename
                              OS status X Y N E OS DISK AGGREGATE);
          %$_ = () foreach qw(config TYPE IP DESC SDESC SPEED DHCP DHCP_STATIC
                              OSPF_BROADCAST OSPF_NEIGHBORS MODE ESSID CHANNEL
                              POLAR ANTENNA GAIN DIRECTION BEAMWIDTH CABLE
                              HEIGHT ROUTE);
        #end cleanup
        
        #load config file
        do($file) || die("Cann't open file");
        
        #parse de config om hem snel en makkelijk te kunnen gebruiken  
        print STDERR "\t Parsing config...";
          parse_config;
        print STDERR "DONE\n";
        clean_ip($master_ip,$nodename);
        foreach $key (keys %IP) {
           clean_ip($IP{$key},$nodename);
        }
    }
    
}; #end main

main;
exit 0;


