#!/usr/bin/perl
# use strict;
use Data::Dumper;

$|++;

my $DIR='../nodes';
my @nodes=();

opendir(DIR,$DIR) or die $!;

my $nodes = \();

foreach(readdir(DIR)) {
	next unless m/[CH]Node[\w+]/;
	# print STDERR "Working on: $_\n";
	my $n = $_;
	my $f = $DIR.'/'.$n.'/wleiden.conf';
	next unless -r $f;
	eval qq|
		package $n;
		require "$f";
		\$\::nodes->{$n} = \{
			'location' => \$location,
			'master_ip' => \$master_ip,
			'nodename' => \$nodename,
			'X' => \$X,
			'Y' => \$Y,
			'config' => \{ %config },
		};
		1;
	|;
	die "Parse error: $@" if $@;
	push @nodes, $_;
};

foreach my $n (@nodes) {
	$c = $::nodes->{$n}->{config};
	foreach my $if (keys %$c ) {
		foreach(split(m/\n/,$c->{$if})) {
			chomp;
			s/#.*//;
			next if m/^\s*$/;
			die unless my ($k,$v) = split /=/;
			# print "$n\t$if\t$k\t$v\n";
			$::nodes->{$n}->{ifaces}->{$if}->{$k}=$v;
		};
	};
	delete  $::nodes->{$n}->{config};
}

print Dumper($::nodes);

