#include <stdio.h>
#include <io.h>
#include <time.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#define BOOL unsigned int
#define FALSE (0==1)
#define TRUE (0==0)

typedef struct
{
   char volgnr[4];
   char location[100]; 
   char master_ip[20];
   char gw_open[10];
   char nodetype[10];
   char nodename[30];
   char status[10];
   char OS[20];
   char labelpos[30];
   char X[10];
   char Y[10];
   char N[10];
   char E[10];
   char ESSID[34];
} CNODE;

typedef struct
{
   char volgnr[4];
   char nodenr[4];
   char configname[10];
   char sprintfname[10];
   char type[10]; 
   char ip[20];
   char desc[20];
   char sdesc[20];
   char speed[20];

   char pointtopoint[20];

   char ospfbroadcast[6];
   char ospfneighbors[20];

   char mode[10];
   char essid[34];
   char channel[3];

   char polar[6];
   char antenna[10];
   char gain[10];
   char direction[6];
   char beamwidth[6];
   char cable[3];
   char heigth[4];

   char dhcp[8];
} CARD;


void LeesNode(void);
void BehandelRegel(void);
void FormatRegel(void);
void MaakCSV(void);
void AddKomma(void);
void AddTekst(void);

char fn[50];
char buf[50];
#define BUFLEN 1000
char Tekstbuf[BUFLEN];
char Regelbuf[BUFLEN];
char Formatbuf[BUFLEN];
FILE *hConf;
size_t numread,toread;
CNODE CNode[100];
CARD Card[500];
int NodeTeller;
int CardTeller;
BOOL bCardBezig;

main()
{
   //doorzoek mappen
   struct _finddata_t c_file;
   long hFile;
   NodeTeller=0;
   CardTeller=0;

   /* Find first CNode directory in current directory */
   if( (hFile = _findfirst( "c:\\nodes\\CNode*.*", &c_file )) == -1L )
       printf( "No CNode directories in current directory!\n" );
   else do
   {
      sprintf(fn,"c:\\nodes\\%s\\wleiden.conf",c_file.name);
      printf(fn);
      printf("\n");

      if (hConf=fopen(fn,"r"))
      {
         LeesNode();
         fclose(hConf);
      }
      NodeTeller++;
      /* Find the rest of the CNode directories */
   }
   while( _findnext( hFile, &c_file ) == 0 );
   _findclose( hFile );
   sprintf(buf,"\naantal nodes: %i\n\r",NodeTeller);
   printf(buf);
   MaakCSV();
   return 0;
}

void LeesNode(void)
{
   char *pos;
   int regels=0;
   int rest;
   bCardBezig=FALSE;

   toread=BUFLEN;
   numread=fread(Tekstbuf,sizeof(char),toread,hConf);

   memset((char*)&(CNode[NodeTeller]),'\0',sizeof(CNode[NodeTeller]));
   pos=strtok(Tekstbuf,"\n\r" );
   while (pos)
   {
      unsigned j;
      strcpy(Regelbuf,Tekstbuf);
      rest=strlen(Regelbuf);
      for (j=0;j<numread-rest-1;j++)
      {
         Tekstbuf[j]=Tekstbuf[j+rest+1]; //tekst naar links schuiven
      }
      if (numread==BUFLEN)
      {
         numread-=(rest+1);
         numread+=fread(Tekstbuf+numread,sizeof(char),rest+1,hConf);
         if (numread<BUFLEN) Tekstbuf[numread]='\0';
      }
      else
      {
         numread-=(rest+1);
         Tekstbuf[numread]='\0';
      }

      BehandelRegel();
      strcat(Formatbuf,"\n");
      printf(Formatbuf);
      regels++;
      pos=strtok(Tekstbuf,"\n\r" );
   }
   sprintf(buf,"\naantal regels: %i\n\r",regels);
   printf(buf);
}

void FormatRegel(void)
{
   char *pos=Regelbuf;
   char *pose=Formatbuf;
   BOOL bDescFlag;

   {
      //vervang # door \0
      char *posd=pos;
      while (*posd!='#'&&*posd!='\0') posd++;
      *posd='\0';
   }
   {
      //vervang /" door /'
      char *posd=pos;
      while (*posd!='\0') 
      {
         if (*posd=='\"') *posd='\'';
         posd++;
      }
   }
   while (pos[strlen(pos)-1]==' ') //skip trailing spaces
   {
      pos[strlen(pos)-1]='\0';
   }
   if (pos[strlen(pos)-1]==';') //skip trailing ;
   {
      pos[strlen(pos)-1]='\0';
   }
   if (pos[strlen(pos)-1]=='\'') //skip trailing '
   {
      pos[strlen(pos)-1]='\0';
   }
   while (pos[strlen(pos)-1]==' ') //skip trailing spaces
   {
      pos[strlen(pos)-1]='\0';
   }
   while (*pos==' '||*pos=='\t'||*pos=='\n'||*pos=='\r') pos++;//skip leading spaces

   bDescFlag=(!memicmp(pos,"DESC",4)); //bij DESC spaties laten
   for (;*pos!='\0';pos++)
   {
      while (!bDescFlag&&(*pos==' '||*pos=='\t')) pos++;//skip spaces
      if (*pos=='\'') //neem tekst tussen quotes letterlijk over
      {               //tot volgende quote of eind
         *pose++=*pos++;
         while (*pos!='\''&&*pos!='\0')
         {
            if (*pos==',') pos++; //geen komma's ivm csv-list
            *pose++=*pos++;
         }
      }
      *pose++=*pos;
   }
   *pose='\0';
   strcpy(Regelbuf,Formatbuf);
}

void BehandelRegel(void)
{
   char *pos=Regelbuf;
   CNODE *pCN=&CNode[NodeTeller];
   CARD *pCd=&Card[CardTeller];
   FormatRegel();
   
   if (!bCardBezig)
   {
      if (!memicmp(pos,"$location='",11)) strncpy(pCN->location,pos+11,sizeof(pCN->location));
      else if (!memicmp(pos,"$master_ip='",12))
      {
         sprintf(pCN->volgnr,"%3d",NodeTeller); //hier want t hoeft maar 1 keer
         strncpy(pCN->master_ip,pos+12,sizeof(pCN->master_ip));
      }
      else if (!memicmp(pos,"$gw_open='",10)) strncpy(pCN->gw_open,pos+10,sizeof(pCN->gw_open));
      else if (!memicmp(pos,"$nodetype='",11)) strncpy(pCN->nodetype,pos+11,sizeof(pCN->nodetype));
      else if (!memicmp(pos,"$nodename='",11)) strncpy(pCN->nodename,pos+11,sizeof(pCN->nodename));
      else if (!memicmp(pos,"$status='",9)) strncpy(pCN->status,pos+9,sizeof(pCN->status));
      else if (!memicmp(pos,"$OS='",5)) strncpy(pCN->OS,pos+5,sizeof(pCN->OS));
      else if (!memicmp(pos,"$labelpos='",11)) strncpy(pCN->labelpos,pos+11,sizeof(pCN->labelpos));
      else if (!memicmp(pos,"$X='",4)) strncpy(pCN->X,pos+4,sizeof(pCN->X));
      else if (!memicmp(pos,"$Y='",4)) strncpy(pCN->Y,pos+4,sizeof(pCN->Y));
      else if (!memicmp(pos,"$N='",4)) strncpy(pCN->N,pos+4,sizeof(pCN->N));
      else if (!memicmp(pos,"$E='",4)) strncpy(pCN->E,pos+4,sizeof(pCN->E));
      else if (!memicmp(pos,"$ESSID='",8)) strncpy(pCN->ESSID,pos+8,sizeof(pCN->ESSID));
      
      else if (!memicmp(pos,"$config{'",9))
      {
         unsigned int len;
         char *pos1=pos+9;
         while(*pos1++!='\'');
         len=pos1-pos-10;
         if (len>9) len=9;
         memcpy(pCd->configname,pos+9,len);
         pCd->configname[len]='\0';
         sprintf(pCd->volgnr,"%3d",CardTeller); //hier want t hoeft maar 1 keer
         sprintf(pCd->nodenr,"%3d",NodeTeller); //hier want t hoeft maar 1 keer
         strncpy(pCd->sprintfname,pos+len+21,sizeof(pCd->sprintfname));
         bCardBezig=TRUE;
      }
   }
   else /*if (bCardBezig)*/
   {
      if (!memicmp(pos,pCd->sprintfname,strlen(pCd->sprintfname)))
      {
         CardTeller++;
         bCardBezig=FALSE;
      }
      else if (!memicmp(pos,"TYPE=",5)) strncpy(pCd->type,pos+5,sizeof(pCd->type));
      else if (!memicmp(pos,"IP=",3)) strncpy(pCd->ip,pos+3,sizeof(pCd->ip));
      else if (!memicmp(pos,"DESC=",5)) strncpy(pCd->desc,pos+5,sizeof(pCd->desc));
      else if (!memicmp(pos,"SDESC=",6)) strncpy(pCd->sdesc,pos+6,sizeof(pCd->sdesc));
      else if (!memicmp(pos,"SPEED=",6)) strncpy(pCd->speed,pos+6,sizeof(pCd->speed));
      else if (!memicmp(pos,"POINT_TO_POINT=",15)) strncpy(pCd->pointtopoint,pos+15,sizeof(pCd->pointtopoint));
      else if (!memicmp(pos,"OSPF_BROADCAST=",15)) strncpy(pCd->ospfbroadcast,pos+15,sizeof(pCd->ospfbroadcast));
      else if (!memicmp(pos,"OSPF_NEIGHBORS=",15)) strncpy(pCd->ospfneighbors,pos+15,sizeof(pCd->ospfneighbors));
      else if (!memicmp(pos,"DHCP=",5)) strncpy(pCd->dhcp,pos+5,sizeof(pCd->dhcp));
      else if (!memicmp(pos,"MODE=",5)) strncpy(pCd->mode,pos+5,sizeof(pCd->mode));
      else if (!memicmp(pos,"ESSID=",6)) strncpy(pCd->essid,pos+6,sizeof(pCd->essid));
      else if (!memicmp(pos,"CHANNEL=",8)) strncpy(pCd->channel,pos+8,sizeof(pCd->channel));
      else if (!memicmp(pos,"POLAR=",6)) strncpy(pCd->polar,pos+6,sizeof(pCd->polar));
      else if (!memicmp(pos,"ANTENNA=",8)) strncpy(pCd->antenna,pos+8,sizeof(pCd->antenna));
      else if (!memicmp(pos,"GAIN=",5)) strncpy(pCd->gain,pos+5,sizeof(pCd->gain));
      else if (!memicmp(pos,"DIRECTION=",10)) strncpy(pCd->direction,pos+10,sizeof(pCd->direction));
      else if (!memicmp(pos,"BEAMWIDTH=",10)) strncpy(pCd->beamwidth,pos+10,sizeof(pCd->beamwidth));
      else if (!memicmp(pos,"CABLE=",6)) strncpy(pCd->cable,pos+6,sizeof(pCd->cable));
      else if (!memicmp(pos,"HEIGTH=",7)) strncpy(pCd->heigth,pos+7,sizeof(pCd->heigth));
   }
}

void MaakCSV(void)
{
   int i;
   CNODE *pCN;
   CARD *pCd;
   if (hConf=fopen("c:\\nodes\\configs.csv","w"))
   {
//      strcpy(buf,"Volgnr");AddTekst();AddKomma();
      strcpy(buf,"location");AddTekst();AddKomma();
      strcpy(buf,"master_ip");AddTekst();AddKomma();
      strcpy(buf,"gw_open");AddTekst();AddKomma();
      strcpy(buf,"nodetype");AddTekst();AddKomma();
      strcpy(buf,"nodename");AddTekst();AddKomma();
      strcpy(buf,"status");AddTekst();AddKomma();
      strcpy(buf,"OS");AddTekst();AddKomma();
      strcpy(buf,"labelpos");AddTekst();AddKomma();
      strcpy(buf,"X");AddTekst();AddKomma();
      strcpy(buf,"Y");AddTekst();AddKomma();
      strcpy(buf,"N");AddTekst();AddKomma();
      strcpy(buf,"E");AddTekst();AddKomma();
      strcpy(buf,"ESSID");AddTekst();AddKomma();
//      strcpy(buf,"volgnr");AddTekst();AddKomma();
      strcpy(buf,"configname");AddTekst();AddKomma();
      strcpy(buf,"sprintfname");AddTekst();AddKomma();
      strcpy(buf,"type");AddTekst();AddKomma();
      strcpy(buf,"ip");AddTekst();AddKomma();
      strcpy(buf,"desc");AddTekst();AddKomma();
      strcpy(buf,"sdesc");AddTekst();AddKomma();
      strcpy(buf,"speed");AddTekst();AddKomma();
      strcpy(buf,"point_to_point");AddTekst();AddKomma();
      strcpy(buf,"ospf_broadcast");AddTekst();AddKomma();
      strcpy(buf,"ospf_neighbors");AddTekst();AddKomma();
      strcpy(buf,"dhcp");AddTekst();AddKomma();
      strcpy(buf,"mode");AddTekst();AddKomma();
      strcpy(buf,"essid");AddTekst();AddKomma();
      strcpy(buf,"channel");AddTekst();AddKomma();
      strcpy(buf,"polar");AddTekst();AddKomma();
      strcpy(buf,"antenna");AddTekst();AddKomma();
      strcpy(buf,"gain");AddTekst();AddKomma();
      strcpy(buf,"direction");AddTekst();AddKomma();
      strcpy(buf,"beamwidth");AddTekst();AddKomma();
      strcpy(buf,"cable");AddTekst();AddKomma();
      strcpy(buf,"heigth");AddTekst();AddKomma();

      fwrite( "\n", sizeof( char ), 1, hConf );

      for (i=0;i<CardTeller;i++)
      {
         pCd=&Card[i];
         pCN=&CNode[atoi(pCd->nodenr)];
//         fwrite( pCN->volgnr, sizeof( char ), strlen(pCN->volgnr), hConf );AddKomma();
         fwrite( pCN->location, sizeof( char ), strlen(pCN->location), hConf );AddKomma();
         fwrite( pCN->master_ip, sizeof( char ), strlen(pCN->master_ip), hConf );AddKomma();
         fwrite( pCN->gw_open, sizeof( char ), strlen(pCN->gw_open), hConf );AddKomma();
         fwrite( pCN->nodetype, sizeof( char ), strlen(pCN->nodetype), hConf );AddKomma();
         fwrite( pCN->nodename, sizeof( char ), strlen(pCN->nodename), hConf );AddKomma();
         fwrite( pCN->status, sizeof( char ), strlen(pCN->status), hConf );AddKomma();
         fwrite( pCN->OS, sizeof( char ), strlen(pCN->OS), hConf );AddKomma();
         fwrite( pCN->labelpos, sizeof( char ), strlen(pCN->labelpos), hConf );AddKomma();
         fwrite( pCN->X, sizeof( char ), strlen(pCN->X), hConf );AddKomma();
         fwrite( pCN->Y, sizeof( char ), strlen(pCN->Y), hConf );AddKomma();
         fwrite( pCN->N, sizeof( char ), strlen(pCN->N), hConf );AddKomma();
         fwrite( pCN->E, sizeof( char ), strlen(pCN->E), hConf );AddKomma();
         fwrite( pCN->ESSID, sizeof( char ), strlen(pCN->ESSID), hConf );AddKomma();
//         fwrite( pCd->volgnr, sizeof( char ), strlen(pCd->volgnr), hConf );AddKomma();
         fwrite( pCd->configname, sizeof( char ), strlen(pCd->configname), hConf );AddKomma();
         fwrite( pCd->sprintfname, sizeof( char ), strlen(pCd->sprintfname), hConf );AddKomma();
         fwrite( pCd->type, sizeof( char ), strlen(pCd->type), hConf );AddKomma();
         fwrite( pCd->ip, sizeof( char ), strlen(pCd->ip), hConf );AddKomma();
         fwrite( pCd->desc, sizeof( char ), strlen(pCd->desc), hConf );AddKomma();
         fwrite( pCd->sdesc, sizeof( char ), strlen(pCd->sdesc), hConf );AddKomma();
         fwrite( pCd->speed, sizeof( char ), strlen(pCd->speed), hConf );AddKomma();
         fwrite( pCd->pointtopoint, sizeof( char ), strlen(pCd->pointtopoint), hConf );AddKomma();
         fwrite( pCd->ospfbroadcast, sizeof( char ), strlen(pCd->ospfbroadcast), hConf );AddKomma();
         fwrite( pCd->ospfneighbors, sizeof( char ), strlen(pCd->ospfneighbors), hConf );AddKomma();
         fwrite( pCd->dhcp, sizeof( char ), strlen(pCd->dhcp), hConf );AddKomma();
         fwrite( pCd->mode, sizeof( char ), strlen(pCd->mode), hConf );AddKomma();
         fwrite( pCd->essid, sizeof( char ), strlen(pCd->essid), hConf );AddKomma();
         fwrite( pCd->channel, sizeof( char ), strlen(pCd->channel), hConf );AddKomma();
         fwrite( pCd->polar, sizeof( char ), strlen(pCd->polar), hConf );AddKomma();
         fwrite( pCd->antenna, sizeof( char ), strlen(pCd->antenna), hConf );AddKomma();
         fwrite( pCd->gain, sizeof( char ), strlen(pCd->gain), hConf );AddKomma();
         fwrite( pCd->direction, sizeof( char ), strlen(pCd->direction), hConf );AddKomma();
         fwrite( pCd->beamwidth, sizeof( char ), strlen(pCd->beamwidth), hConf );AddKomma();
         fwrite( pCd->cable, sizeof( char ), strlen(pCd->cable), hConf );AddKomma();
         fwrite( pCd->heigth, sizeof( char ), strlen(pCd->heigth), hConf );AddKomma();
         fwrite( "\n", sizeof( char ), 1, hConf );
      }
      fclose(hConf);
   }
}

void AddKomma(void)
{
   fwrite( ",", sizeof( char ), 1, hConf );
}



void AddTekst(void)
{
   fwrite( buf, sizeof( char ), strlen(buf), hConf );
}
