(**
  experiment met evolutionary programming voor de kanalenplanning
  het genetische zit er nu nauwelijks in, en wat er in zit is ongetwijfeld
  fout. wat er wel goed in zit is het parseren van de bestaande situatie en
  het scoren van (nu random) configuraties.

  de score functie is nu redelijk simplistisch:
    - de score van een combinatie van twee interfaces op een node is 1 als er
      twee of meer kanalen tussen zitten, en -1 als er 1 kanaal tussen zit, -5
      als er geen kanaal tussen zit en -10 als de kanalen hetzelfde zijn
    - de score van een node is de som van de scores van alle combinaties van
      interfaces van die node, maal het aantal interfaces. dat laatste omdat
      een positieve score hebben knapper is met meer interfaces dan met minder,
      dus dat moet beloond. een negatieve score is erger met meer interfaces
      (belangrijker node, waarschijnlijk) dan met minder, dus dat moet
      bestraft.
    - de totale score is de som van de scores van de nodes

  het stukje "genetisch" aan het einde is afgeraffeld. mutation en
  recombination gebeuren op de oplossing zelf ipv op een bitstring
  representatie. selection is dom en neemt gewoon de helft beste oplossingen.

  lvoge@cs.vu.nl *)

(** How large a population should the system maintain *)
val population_size : int
(** The maximum number of iterations to try to improve *)
val max_stagnant_iterations : int
(** The chance a solution element (channel assignment) will change *)
val mutation_rate : float

type wi = {
	wi_name : string;
	wi_nodename : string;
	wi_essid : string;
}
and group = { group_essid : string; mutable group_wis : wi list; }
and node = { node_name : string; node_wis : wi list; }

(** Global hashtable mapping from nodename to node record *)
val nodes : (string, node) Hashtbl.t
(** Global hashtable mapping from essid to group record *)
val groups : (string, group) Hashtbl.t

(** Given two functions, return the composition of these functions *)
val compose : ('a -> 'b) -> ('c -> 'a) -> 'c -> 'b
(** Shorthand for compose *)
val ( $ ) : ('a -> 'b) -> ('c -> 'a) -> 'c -> 'b
(** Shorthand for List.hd *)
val head : 'a list -> 'a
(** Shorthand for List.tl *)
val tail : 'a list -> 'a list
val maketuple : 'a -> 'b -> 'a * 'b
(** Given a hashtable, return a list of its keys *)
val keys : ('a, 'b) Hashtbl.t -> 'a list
(** Given a hashtable, return a list of its values *)
val values : ('a, 'b) Hashtbl.t -> 'b list
(** Copy the given array into the other given array *)
val copyarray : 'a array -> 'a array -> unit
(** Given a list, return a list of pairs of all combinations of elements from the given list *)
val combinations : 'a list -> ('a * 'a) list
val wi_score : (string -> int) -> wi -> wi -> int
val node_score : (string -> int) -> node -> int
val score_configuration : (string, int) Hashtbl.t -> node list -> int
val snarf_lines : string -> string list
val parse_pair : string -> string * string -> wi
val parse_fields : string list -> unit
val parse_file : string -> unit
val random_configuration : ('a, 'b) Hashtbl.t -> ('a, int) Hashtbl.t
val mutate : (string, int) Hashtbl.t array -> int -> unit
val print_conf : (string, int) Hashtbl.t -> unit
val main : unit
