#!/usr/bin/env python
#
# Quick to generate large (A1 size) image of node locations
#
import io, urllib2, datetime, time, re, random
import math
from PIL import Image, ImageDraw

import make_network_kml

def num2deg(xtile, ytile, zoom):
  n = 2.0 ** zoom
  lon_deg = xtile / n * 360.0 - 180.0
  lat_rad = math.atan(math.sinh(math.pi * (1 - 2 * ytile / n)))
  lat_deg = math.degrees(lat_rad)
  return (lat_deg, lon_deg)

## bigmap_leiden
#(zoom, xmin, ymin, xmax, ymax) = (16, 33568, 21592, 33599, 21615)
# bigmap_region
(zoom, xmin, ymin, xmax, ymax) = (14, 8379, 5390, 8417, 5416)


(lat_nw, lon_nw) = num2deg(xmin, ymin, zoom)
(lat_se, lon_se) = num2deg(xmax + 1, ymax + 1, zoom)

delta_lat = lat_nw - lat_se
delta_lon = lon_nw - lon_se
print (lat_nw, lon_nw)
print (lat_se, lon_se)

xpixels = (xmax - xmin + 1) * 256
ypixels = (ymax - ymin + 1) * 256
print (xpixels, ypixels)


debug=False

# Input data
poel, link_type, link_data, link_status, hosts = make_network_kml.get_graph_data(debug)

# Input image
#resultImage = Image.open("map16-190204-2154.png")
resultImage = Image.open("map14-190204-2329.png")
draw = ImageDraw.Draw(resultImage)

coord = {}
# Draw nodes
for nodename, datadump in hosts.iteritems():
    lat_y = (lat_nw - float(datadump['latitude'])) / delta_lat * ypixels
    lon_x = (lon_nw - float(datadump['longitude'])) / delta_lon * xpixels
    coord[nodename] = (lon_x, lat_y)
    r = 20
    draw.ellipse((lon_x - r, lat_y - r, lon_x + r, lat_y + r), fill = 'blue', outline ='blue')

# Draw links
for addr,leden in poel.iteritems():
  for index,lid in enumerate(leden[:-1]):
    for buur in leden[index + 1:]:
        x1, y1 = coord[hosts[buur]['nodename']]
        x2, y2 = coord[hosts[lid]['nodename']]
        draw.line((x1, y1, x2, y2), fill = 'green', width = 5)

del draw

now = datetime.datetime.now()
outputFileName = "foo.png"
resultImage.save(outputFileName)
