#!/usr/bin/env python

import gformat

nodes = gformat.get_nodelist()

def list_ips(ip):
  addr, mask = ip.split('/')[0], ip.split('/')[1]

  mask = 2 ** (32 - int(mask))
  mask = int(mask)
  addr = addr.split('.')
  fourth = addr[3]
  fourth = int(fourth)
  start = fourth - (fourth % mask)
  start = int(start)
  end   = int(start) + int(mask)
  end   = int(end)

  listing = []
  for i in range(start, end):
    ip2 = "%s.%s.%s.%i" % (addr[0], addr[1], addr[2], i)
    listing.append(ip2)

  return listing

f = open('client-ips.txt','w')

for node in nodes:
  ifaces = gformat.get_yaml(node)['interfaces'].split(',')
  for iface in ifaces:
    if gformat.get_yaml(node)['iface_%s' % iface]['dhcp'] == "no" : 
      continue
    if gformat.get_yaml(node)['iface_%s' % iface]['dhcp'] == "False" : 
      continue
    ip = gformat.get_yaml(node)['iface_%s' % iface]['ip']
    ip = gformat.get_yaml(node)['iface_%s' % iface]['ip']
    node_short = node.replace('CNode', '').lower()
    for client in list_ips(ip):
      f.write("%s %s\n" % (node_short, client))

f.close()
