#!/usr/bin/env python
# vim:ts=2:et:sw=2:ai
#
# Build topological network graph
# Rick van der Zwet <info@rickvanderzwet.nl>
import gformat
import glob
import os
import re
import subprocess
import sys
import tempfile
import yaml

OUTFILE = os.path.join(os.getcwd(),'network.kml')

store = yaml.load(open('store.yaml','r'))


HEADER = '''<?xml version="1.0" encoding="UTF-8"?>
<kml xmlns="http://www.opengis.net/kml/2.2">
<Document>
'''

POINT = '''
  <Placemark>
    <name>%(nodename)s</name>
    <description>%(nodename)s</description>
    <Point>
      <coordinates>%(latitude)s,%(longitude)s,0</coordinates>
    </Point>
  </Placemark>
'''

LINE = '''
   <Placemark>
      <LineString>
        <coordinates>
          %(latitudeA)s,%(longitudeA)s,0
          %(latitudeB)s,%(longitudeB)s,0
        </coordinates>
      </LineString>
    </Placemark>
'''

FOOTER = '''
</Document>
</kml>
'''
def make_graph():
  poel = {}
  link_type = {}
  link_data = {}
  hosts = {}
  try:
    for host in gformat.get_hostlist():
      print "## Processing host", host
      datadump = gformat.get_yaml(host)
      nodename = datadump['nodename']
      hosts[nodename] = datadump

      iface_keys = [elem for elem in datadump.keys() if (elem.startswith('iface_') and not "lo0" in elem)]
      for iface_key in iface_keys:
        l = datadump[iface_key]['ip']
        addr, mask = l.split('/')

        # Not parsing of these folks please
        if not gformat.valid_addr(addr):
          continue

        addr = gformat.parseaddr(addr)
        mask = int(mask)
        addr = addr & ~((1 << (32 - mask)) - 1)
        if poel.has_key(addr):
          poel[addr] += [nodename]
        else:
          poel[addr] = [nodename]
          # Assume all ns_ip to be 11a for a moment
          if datadump[iface_key].has_key('ns_ip'):
            link_type[addr] = '11a'
          else:
            link_type[addr] = datadump[iface_key]['type']

          link_data[addr] = 1
          iface = datadump[iface_key]['interface']
          nodename = datadump['nodename']
          INTERVAL = 60 * 10
          if store['uptime'].has_key(nodename) and store['snmp'].has_key(nodename) and store['traffic'].has_key(nodename):
            if store['traffic'][nodename].has_key(iface):
              (b_in, b_out) = store['traffic'][nodename][iface]
              uptime = store['uptime'][nodename]
              t_kb = float(b_in + b_out) / 1024
              print "# INFO: Found %s kB in %s seconds" % (t_kb, INTERVAL)
              retval = ((t_kb) / uptime) * INTERVAL
              link_data[addr] = retval

          print "### %s [%s] is of type %s" % (gformat.showaddr(addr), iface_key, link_type[addr])
  except (KeyError, ValueError), e:
    print "[FOUT] in '%s' interface '%s'" % (host,iface_key)
    print e
    sys.exit(1)

  f = open(OUTFILE,'w')
  sys.stderr.write("# Building KML file\n")
  print >> f, HEADER
  for nodename, datadump in hosts.iteritems():
    print >> f, POINT % datadump

  for addr,leden in poel.iteritems():
    if link_type[addr] == '11a':
      color = 'green'
      weight = 4
    elif link_type[addr] == 'eth':
      color = 'blue'
      weight = 8
    else:
      color = 'black'
      weight = 1
    width = max(1,link_data[addr])
    leden = sorted(set(leden))
    for index,lid in enumerate(leden[:-1]):
      for buur in leden[index + 1:]:
        keys = {}
        for key, value in hosts[buur].iteritems():
           keys[key + 'A'] = value
        for key, value in hosts[lid].iteritems():
           keys[key + 'B'] = value
        print >> f, LINE % keys
  print >> f, FOOTER
  f.flush()
  sys.stderr.write("# COMPLETED find your output in %s\n" % OUTFILE)

if __name__ == "__main__":
  make_graph()

