#!/bin/sh

PROXY=proxy.wleiden.net:3128
URL=http://proxy-test.wirelessleiden.nl
FILE=/tmp/proxy-test.wirelessleiden.nl

# Set proxy to escape the network
export HTTP_PROXY=${PROXY}

# Fetch the website (curl not installed)
fetch -o ${FILE} ${URL} 2> /dev/null
if [ -w ${FILE} ]; then
  retval=`cat ${FILE}`
  rm ${FILE}
fi

# Chech if website returns the expected result
if [ "$retval" = "1" ]; then
  echo "WWW OK: Got a www website"
  exit 0
else
  echo "WWW CRITICAL: Unable to fetch www website"
  exit 2
fi

