--- tools/duende.c.orig	2011-11-12 09:25:42.000000000 +0100
+++ tools/duende.c	2012-02-11 01:32:42.000000000 +0100
@@ -35,6 +35,7 @@
 #include <signal.h>
 #include <stdio.h>
 #include <stdlib.h>
+#include <string.h>
 #include <syslog.h>
 #include <sys/time.h>
 #include <sys/types.h>
@@ -66,9 +67,20 @@
     /* We can't use our signal handlers because fgets is blocking */
     signal(SIGTERM,SIG_DFL);
     signal(SIGHUP,SIG_DFL);
+    
+    /* Prefix MaraDNS syslog messages with ident of "maradns:" 
+       instead of "/usr/local/sbin/maradns:" */
+    char *needle, *ident;
+    needle = strrchr(name,'/');
+    /* needle found and not at the end of string */
+    if (needle && *(needle + 1) != '\0') {
+        ident = needle + 1;
+    } else {
+        ident = name;
+    }       
 
     /* Open up the sys log */
-    openlog(name,0,LOG_DAEMON);
+    openlog(ident,0,LOG_DAEMON);
 
     /* Drop all privileges */
     if(chdir(DUENDE_CHROOT_DIR) != 0) {
