# Make sure to only load this file ones, even if sourced from multiple
# locations, preventing weird and wonderfull errors of relative paths.
if [ -n "$PACKAGE_BUILD_INC_SH" ]; then
  return
fi
PACKAGE_BUILD_INC_SH=true

# Used to store profile data
TIME_FILE=$(dirname $0)/eta-times.txt

p_list () {
echo "$*" | sed -e 's/ /|## /g' -e 's/^/## /g'
}

p_info () {
  echo "$*" | tr '|' '\n' | sed 's/^/# /'
}

p_warn () {
  echo "$*" | tr '|' '\n' | sed 's/^/#WARN: /'
}

p_err () {
  echo "$*" | tr '|' '\n' | sed 's/^/#ERR: /'
}

p_sleep() {
  SLEEP=${1-5}
  while [ "${SLEEP}" -gt 0 ]; do
    printf '.'
    sleep 1
    SLEEP=`expr ${SLEEP} - 1`
  done
  printf '\n'
}

# Print estimation on how long it normally if going to take
f_time() {
  COMMAND="$*"
  ETA_TIME=` grep "${COMMAND}$" ${TIME_FILE} 2>/dev/null | awk '{print $1}'`
  if [ -z "${ETA_TIME}" ]; then
    ETA_TIME="NaN"
  fi
  
  p_info Last run of "'${COMMAND}'" took ${ETA_TIME}
  p_info Start time: `date`
  
  # Execute command
  START_TIME=`date "+%s"`
  $COMMAND
  RETVAL=$?
  STOP_TIME=`date "+%s"`
  
  p_info End time: `date`
  # Calculate time it took
  TOTAL_TIME=`expr ${STOP_TIME} - ${START_TIME}`
  HUMAN_FMT=`date -ur ${TOTAL_TIME} "+%H:%M:%S"`
  
  # Store new time if command is succesfull
  if [ "${RETVAL}" -eq 0 ]; then
    grep -v "${COMMAND}$" ${TIME_FILE} > ${TIME_FILE}.tmp 2>/dev/null
    echo "${HUMAN_FMT} ${COMMAND}" >> ${TIME_FILE}.tmp
    mv ${TIME_FILE}.tmp ${TIME_FILE}
  fi
  
  # Return the command it's output
  return ${RETVAL}
}

f_check_root() {
  # No Root, no fun
  if [ `id -u` -ne 0 ]; then
  	print_err Root only
  	exit 1
  fi
}

# Find object directory 
BASEDIR=`dirname $0`

# Load the NanoBSD Configuration entries 
NANO_CFG_FILE="${BASEDIR}/../cfg/nanobsd.wleiden"
customize_cmd() { return; }
late_customize_cmd() { return; }
. $NANO_CFG_FILE

OBJDIR="/usr/obj/nanobsd.${NANO_NAME}"

