#!/bin/sh
# Rsync minimal changes directly to live image

. $(dirname $0)/package-build.inc.sh

HOST=${1:-10.0.42.1}
BASEDIR=`dirname $0`
if [ -n "$2" ]; then
  IMG=$2
else
  CFG="${BASEDIR}/../cfg/nanobsd.wleiden"
  
  # Find object directory 
  eval `grep '^NANO_NAME=' ${CFG}`
  OBJDIR="/usr/obj/nanobsd.${NANO_NAME}"
  IMG=${OBJDIR}/_.disk.image
fi

if [ ! -r "${IMG}" ]; then
  p_err Source ${IMG} does not exists
fi

# Make sure we are root from this point on
f_check_root


# Prepare image as filesystem
MNT=`mktemp -d -t $(basename $0)`
MD=`mdconfig -a -t vnode -f ${IMG}`
mount /dev/${MD}a ${MNT} || exit 1

# On error clean up nicely 
trap "cd /; umount ${MNT}; rmdir ${MNT}; mdconfig -d -u ${MD}" 0 1 2 3 15 

#XXX: Might want to do in one fly
# Set to write mode
ssh $HOST mount -uwo noatime / || exit 1
# Sync changes
rsync -av --exclude=/dev --exclude=/etc --exclude=/var ${MNT}/ ${HOST}:/ || exit 1
# Set to read-only mode again
ssh $HOST mount -ur / || exit 1

exit 0
