#!/bin/sh
#
# Upload image to node and flash partition
#
# Rick van der Zwet <info@rickvanderzwet.nl>

. $(dirname $0)/package-build.inc.sh

if [ -z "$1" ]; then
  echo "Usage: $0 <host1> [<host2> <host3> ..]" 1>&2
  exit 128
fi

BASEDIR=`dirname $0`
CFG="${BASEDIR}/../cfg/nanobsd.wleiden"

# Find object directory 
eval `grep '^NANO_NAME=' ${CFG}`
OBJDIR="/usr/obj/nanobsd.${NANO_NAME}"
IMG=${IMG:-${OBJDIR}/_.disk.image}

if [ ! -r "${IMG}" ]; then
  p_err Source ${IMG} does not exists
fi

for HOST in $*; do
  cat $IMG | ssh -oBatchMode=yes $HOST /tools/update-wrapper
done

