#!/bin/sh
# Small tool to build nanobsd release, ready for distribution:

BASEDIR="`dirname $0`/.."

# Some cleaning at start
for PORT in ${BASEDIR}/misc/ports/*/*; do 
   (cd $PORT; make clean); 
done

# Version target
# Either version from command line or else subversion base
VERSION=${1-`svn info ${BASEDIR} | awk '/Revision:/ {print $2}'`}

TMPDIR=`mktemp -d -t $(basename $0 .sh)`

PKGDIR=wl-image-$VERSION
WRKSRC=$TMPDIR/$PKGDIR
mkdir $WRKSRC
cp -R ${BASEDIR}/tools $WRKSRC
cp -R ${BASEDIR}/cfg $WRKSRC
cp -R ${BASEDIR}/misc $WRKSRC
cp -R ${BASEDIR}/files $WRKSRC
cp -R ${BASEDIR}/README.txt $WRKSRC

# Present real image
# XXX: Make path relative
# XXX: Find some pretty options
IMG=/usr/obj/nanobsd.wleiden/_.disk.full
IMG_DIR=`dirname ${IMG}`
IMG_PKGDIR=${IMG_DIR}/${PKGDIR}
mkdir ${IMG_PKGDIR}
ln  ${IMG} ${IMG_PKGDIR}/disk_full.img

# Make pretty tar file out of it
tar --exclude ".svn" --exclude "Makefile" \
  --exclude "config.cache"  --exclude "config.log" --exclude "config.status" \
  --exclude ".depend" \
  -cjf wl-image-$VERSION.tbz \
  -C $TMPDIR \
  $PKGDIR/tools \
  $PKGDIR/cfg \
  $PKGDIR/files \
  $PKGDIR/misc \
  $PKGDIR/README.txt \
  -C $IMG_DIR \
  $PKGDIR/disk_full.img

rm -fR $TMPDIR
rm -fR $IMG_PKGDIR

