#!/bin/csh
#
# Display some tricks and pointers for management on login.
#
# Rick van der Zwet <rick@wirelessleiden.nl>
#
echo ""
echo "Statistics:"
echo " - Build "`grep 'Revision:' /tools/wl-release.txt`
echo " - Config "`grep Generated /usr/local/etc/wleiden.yaml | tr -d '#'`
setenv cs_conn `arp -na | grep -v -e ' 00:15:6d' -e 'incomplete' -e 'permanent' -e ' 00:0d:b9' | wc -l`
setenv cs_auth `pfctl -twlportal -Tshow | wc -l`
echo " - $cs_conn clients and $cs_auth authenticated"
echo " - "`uptime`
echo ""
echo "Active Bridges:"
arp -na | grep -e ' 00:15:6d' | sed -e 's/^/ - /' | grep ' ' || echo " - none"
echo ""
echo "Active Neighbors:"
arp -a | grep -v 'permanent' | grep ' 00:0d:b9' |\
  sed -e 's/^/ - /' -e 's/.wleiden.net//' -e 's/expires .*$//' |\
  grep ' ' || echo " - none"
echo ""

