#!/usr/bin/env python
# 
# Wireless Leiden webinterface for (embedded) nodes, printing some basic debug
# information, for people who does not like SSH logins
#
# Rick van der Zwet <info@rickvanderzwet.nl>
# Richard van Mansom (richardvm@wirelessleiden.nl), striped the webserver

from subprocess import *
import socket

def tailFile(file, lines=10):
  return("<em>Tail (%i): %s</em><br /><pre>%s</pre>" % (lines,file,Popen(["/usr/bin/tail", '-%s' % lines, file], stdout=PIPE, shell=False).communicate()[0]))

def catFile(file):
  return("<em>File: %s</em><br /><pre>%s</pre>" % (file,Popen(["/bin/cat", file], stdout=PIPE, shell=False).communicate()[0]))

def allRoutes():
  return("<em>netstat -nr</em><br /><pre>%s</pre>" % Popen(["/usr/bin/netstat", "-n", "-r"], stdout=PIPE, shell=False).communicate()[0])

def processList():
  return("<em>ps -aux</em><br /><pre>%s</pre>" % Popen(["/bin/ps", "-a", "-u", "-x"], stdout=PIPE, shell=False).communicate()[0])

def interfaceList():
  return("<em>ifconfig -a</em><br /><pre>%s</pre>" % Popen(["/sbin/ifconfig", "-a"], stdout=PIPE, shell=False).communicate()[0])

def arpList():
  return("<em>arp -n -a</em><br /><pre>%s</pre>" % Popen(["/usr/sbin/arp", "-n", "-a"], stdout=PIPE, shell=False).communicate()[0])


if __name__ == '__main__':
  print "Content-Type: text/html\n\n"
  print "<img src='/static/wl-logo.png' />"
  print "Welcome to <a href='http://www.wirelessleiden.nl'>Stichting Wireless Leiden</a> host/node <em>%s</em>" % socket.gethostname()

  items = ['motd', 'messages', 'debug.log', 'dmesg.boot', 'ps', 'ifconfig', 'arp', 'routes']  
  print "<a name='top'><ul>"
  for item in items:
    print "<li><a href='#{0}'>{0}</a></li>".format(item)
  print '</ul>'

  def item_label():
    return "<a href='#top'>Back to Top</a><a name='%s'></a><p />" % items.pop(0)

  print item_label()
  print catFile('/etc/motd')
  print item_label()
  print tailFile('/var/log/messages')
  print item_label()
  print tailFile('/var/log/debug.log')
  print item_label()
  print catFile('/var/run/dmesg.boot')
  print item_label()
  print processList() + "<p />"
  print item_label()
  print interfaceList() + "<p />"
  print item_label()
  print arpList() + "<p />" 
  print item_label()
  print allRoutes() + "<p />" 
  print "<em>$Id$</em>"
