#!/bin/sh
# Change password if image
#
# XXX: Error handing
. $(dirname $0)/package-build.inc.sh

BASEDIR=`dirname $0`
if [ -n "$1" ]; then
  IMG=$1
else
  CFG="${BASEDIR}/../cfg/nanobsd.wleiden"
  
  # Find object directory 
  eval `grep '^NANO_NAME=' ${CFG}`
  OBJDIR="/usr/obj/nanobsd.${NANO_NAME}"
  IMG=${OBJDIR}/_.disk.full
fi

if [ ! -r "${IMG}" ]; then
  p_err Source ${IMG} does not exists
fi

# Make sure we are root from this point on
f_check_root


MNT=`mktemp -d -t $(basename $0)`

# If target nfs image is mounted somehow, bail out
if mdconfig -l -v | grep -q "${IMG}"; then
	MD=`mdconfig -l -v | grep "${IMG}" | cut -c -4`
	p_err "'${IMG}' already mounted at '$MD'"
	exit 1
fi


MD=`mdconfig -a -t vnode -f ${IMG}`
mount /dev/${MD}s1a ${MNT}

# Config files lives at /cfg  location
mount /dev/${MD}s3 ${MNT}/cfg

# Try to fetch and store config
chroot ${MNT} passwd

# Clean up
umount ${MNT}/cfg
umount ${MNT}
mdconfig -d -u ${MD}
rm -d ${MNT}


