#!/bin/csh
#
# Display some tricks and pointers for management on login.
#
# Rick van der Zwet <rick@wirelessleiden.nl>
#
echo ""
echo "Statistics:"
echo " - Build "`grep 'Revision:' /tools/wl-release.txt`
echo " - Config "`grep Generated /usr/local/etc/wleiden.yaml | tr -d '#'`
setenv cs_conn `arp -na | grep -v -e ' 00:15:6d' -e 'incomplete' -e 'permanent' -e ' 00:0d:b9' | wc -l`
setenv cs_auth `pfctl -twlportal -Tshow | wc -l`
echo " - $cs_conn clients and $cs_auth authenticated"
echo " - "`uptime`
echo ""
echo "Active Bridges:"
# MAC OIDs Ubiquiti Networks 
#
# curl 'https://code.wireshark.org/review/gitweb?p=wireshark.git;a=blob_plain;f=manuf' |\
# awk '{print $1}' | cut -c -8 | tr 'A-Z' 'a-z' | tr '\n' '|'
arp -na | grep -E ' (00:15:6d|00:27:22|00:50:c2|04:18:d6|18:e8:29|24:a4:3c|44:d9:e7|68:72:51|74:83:c2|78:8a:20|80:2a:a8|b4:fb:e4|dc:9f:db|e0:63:da|f0:9f:c2|fc:ec:da)'  | sed -e 's/^/ - /' | grep ' ' || echo " - none"
echo ""
echo "Active Neighbors:"
# MAC OID PC Engines GmbH
arp -na | grep -v 'permanent' | grep -E ' 00:0d:b9' |\
  sed -e 's/^/ - /' -e 's/.wleiden.net//' -e 's/expires .*$//' |\
  grep ' ' || echo " - none"
echo ""

