#!/bin/sh
#
# Compile listing of required packages using poudriere and friends
#
# Rick van der Zwet <rick@wirelessleiden.nl>
#

. `dirname $0`/common.inc.sh

cfg_dir=`dirname $0`/../cfg
poudriere_pkglist_file=${cfg_dir}/wlpkgbuild10_2-default-node-pkglist


packages_initenv() {
	config_dir=`dirname $0`

	# Install required deamons
	pkg install poudriere dialog4ports portshaker

	# Setup poudriere build environment
	poudriere jail -c -j wlpkgbuild10_2 -v 10.2-RELEASE -a i386

	# Setup portshaker
	cp ${config_dir}/portshaker.conf /usr/local/etc/
	cp ${config_dir}/portshaker.d/* /usr/local/etc/portshaker.d

	# Update ports
	portshaker -U
	portshaker -M

	# Setup poudriere ports environment
	poudriere ports -c -F -f none -p default -M /usr/local/poudriere/ports/default

	# Build options
	poudriere options -j wlpkgbuild10_2 -p default -z node -f ${poudriere_pkglist_file}
}

packages_refresh() {
	# Install new package options
	POUDRIERE_MAKE_CONF_FILE=wlpkgbuild10_2-node-make.conf
	POUDRIERE_OPTIONS=wlpkgbuild10_2-node-options

	if [ -d "/usr/local/etc/poudriere.d/$POUDRIERE_OPTIONS" ]; then
	  rm -Rf /usr/local/etc/poudriere.d/$POUDRIERE_OPTIONS
        fi

	cp ${cfg_dir}/$POUDRIERE_MAKE_CONF_FILE /usr/local/etc/poudriere.d
	cp -R ${cfg_dir}/$POUDRIERE_OPTIONS /usr/local/etc/poudriere.d
}


packages_build() {
	poudriere bulk -j wlpkgbuild10_2 -p default -z node -f ${poudriere_pkglist_file}
}

# Make package list
. $cfg_dir/nanobsd.wleiden
echo $PACKAGE_LIST | tr " " "\n" > ${poudriere_pkglist_file}


if [ "x$1" = "xinitenv" ]; then
	packages_initenv
	packages_refresh
elif [ "x$1" = "xrebuild" ]; then
	packages_refresh
	packages_build
elif [ "x$1" = "xbuild" ]; then
	packages_build
else
	echo "Usage $0 <initenv|rebuild|build>"
	exit 128
fi
