#!/usr/bin/env python
#
# Bouw een template Wireless Leiden wleiden.conf voor een nieuwe node
# Rick van der Zwet <info@rickvanderzwet.nl>
import getrange
import sys

__version__ = '$Id: generate-config.py 8615 2010-10-31 19:59:34Z rick $'

if len(sys.argv) <> 2:
    print "Gebruik %s <nodeNaam>" % sys.argv[0]
    print "Configurator versie: %s" % __version__
    exit(1)

nodename = sys.argv[1]
# ALIX/IRIS Boord standaard interfaces
interfaces = "vr0 vr1 vr2 ue0 ue1".split(' ')

# Initieele IP interface, aannemend dat alles master is
master_ip = getrange.get_ranges(False, 24, 1)[0] + 1
interlinks = getrange.get_ranges(True, 29, len(interfaces))

# Maak de boel een beetje standaard
variables = {
        'nodename' : nodename[0].upper() + nodename[1:],
        'nodename_lower' : nodename.lower(),
        'master_ip' : getrange.showaddr(master_ip),
        'version' : __version__ }

# Header
print """
#
# Configuratie voor CNode%(nodename)s
# Configuratie gegenereerd met configurator versie %(version)s
#
location : "Locatie XXX, Straat XXX, XXXX XX, Leiden"
master_ip: '%(master_ip)s'  
nodetype: 'CNode'
nodename: '%(nodename)s'
status: 'up'
release: "8.0-RELEASE"
rndap_x: 'XXXXX'
rNdap_y: 'XXXXXX'
lon: '4.XXX'
lat: '52.XXX'
""" % variables

# Accesspoint
print """
iface_ath0:
  type: wireless
  ip: %(master_ip)s/26
  desc: ap
  sdesc: ap
  dhcp: 10-60
  mode: master
  essid: ap-WirelessLeiden-%(nodename)s
  channel: 8
""" % variables

# Alle interfaces
for index, ifname in enumerate(interfaces):
    print """
iface_%(ifname)s:
  comment: Link naar XXX
  type: ethernet
  extra_type: eth2wifibridge
  ip: %(ip)s/29
  desc: Link naar XXX
  sdesc: 2xxx-%(ifname)s
  mode: XXX
  essid: XX-XX.%(nodename_lower)s.wleiden.net
  channel: XX
  nsmac: 
  ns_ip: %(ns_ip)s/29
  dhcp: no
""" % { 'nodename_lower' : nodename.lower(),
        'ifname' : ifname,
        'ifname_caps' : ifname.upper(),
        'ip' : getrange.showaddr(interlinks[index] + 1),
        'ns_ip' : getrange.showaddr(interlinks[index] + 2) }

