#!/bin/sh
#
# Deploy fresh/changed WL autogenerated DNS zones
#
CONFIGROOT='/usr/home/rvdzwet/genesis/nodes'
DEPLOYROOT='/etc/namedb/master'

TFILE=`mktemp /tmp/$(basename $0).XXXXX`
trap "rm $TFILE; exit 1" 1 2 3 15

# Generate new DNS and only complain/die on errors
(
  svn up $CONFIGROOT $CONFIGROOT/../dns || exit 1
  $CONFIGROOT/genesis-to-yaml.pl $CONFIGROOT/*/wleiden.conf || exit 1
  $CONFIGROOT/gformat.py dns || exit 1
) 2>&1 > $TFILE || { cat $TFILE; exit 1; }


UPDATE_ZONES=""
# Check all zone files for updates
for NEW in $CONFIGROOT/dns/*; do
  ZONE=`basename $NEW | cut -c 4-`  
  OLD=$DEPLOYROOT/`basename $NEW`

  # Contains new data?
  diff -I 'SOA' $OLD $NEW
  if [ $? -eq 0 ]; then
    continue
  fi

  # Syntax valid?
  named-checkzone $ZONE $NEW
  if [ $? -ne 0 ] ; then
    continue
  fi

  # Deploy
  cp $NEW $OLD
  UPDATE_ZONES="$UPDATE_ZONES $ZONE"
done

# Make sure to reload if updates are executed
if [ -n "$UPDATE_ZONES" ]; then
  rndc reload
fi
