#!/usr/bin/perl
$|++;
require "conf.inc"
	or die "Did you run conf2inc.pl > conf.inc ??";

# Make a reverse mapping..
my %ips = ();

foreach my $node (sort keys %$VAR1) {
	foreach my $iface (keys %{ $VAR1->{$node}->{ifaces} }) {
		my $v = $VAR1->{$node}->{ifaces}->{$iface};
		next unless defined $v->{IP};
		$ip = $v->{IP};
		die "IP of $node:$iface malformed ($ip)"
			unless $ip =~ m/([\d\.]+)\/(\d+)/;
		$pip = $1;
		$mask = $2;

		my %info=();
		if ($iface =~ m/([^:]+):(.*)/) {
			my ($a,$b)=($1,$2);
			%info = %{$VAR1->{$node}->{ifaces}->{$a}};
		};
		foreach my $k (keys(%{$v})) {
			$info{ $k } = $v->{$k};
		};
		
		$ips{ $pip } = \%info;
		# print "$node	$iface	$pip	$info{ESSID}\n";
	}
}

foreach my $node (sort keys %$VAR1) {
	my $vals = $VAR1->{$node};
	print qq|<node id="$node" ip="$vals->{master_ip}>
	<location>$vals->{location}</location>
|;
	foreach my $iface (sort keys(%{$vals->{ifaces}})) {
		my $v = $vals->{ifaces}->{$iface};
		print qq|	<iface\tid="$iface"\n|;
		
		if ($v->{TYPE} =~ m/wireless/i) {
			my $ssid = "ERROR!";
			if ($v->{MODE} =~ m/master/i) {
				print qq|\t\tchannel="$v->{CHANNEL}"\n|;
				$ssid = $v->{ESSID};
				print "\t\tmaster\n";
			} else {
				# Channel vollows; ESSID is
				# that of the peer.
				my $pip = $v->{POINT_TO_POINT};
				if (defined $ips{ $pip }) {
					$ssid = $ips{$pip}->{ESSID};
				} else {
					$ssid = 'undefined ('.$pip.')';
				}
			};
			print qq|\t\tssid="$ssid"\n|;
		}
		if ($v->{DHCP} =~ m/(\d+)\-(\d+)/) {
			my $x = $2 - $1;
			print qq|\t\tdhcp="$x"\n|;
		};
		print "\t\t>\n";
		print qq|	</iface>\n|;
	}
	print qq|</node>\n|;
};
