#!/usr/bin/env python
# vim:ts=2:et:sw=2:ai
#
# Build topological network graph
# Rick van der Zwet <info@rickvanderzwet.nl>
import gformat
import sys

__version__ = '$Id: gindent.py 8615 2010-10-31 19:59:34Z rick $'

def gindent(hosts):
  """ Pretty indent all files automatically """
  try:
    for host in hosts:
      print "## Processing host %-20s: " % host,
      datadump = gformat.get_yaml(host)
      gformat.write_yaml(host, datadump)
      print "OK"
  except (KeyError, ValueError), e:
    print "[ERROR] in '%s' interface '%s'" % (host,iface_key) 
    print e
    sys.exit(1)


if __name__ == "__main__":
  if len(sys.argv) == 1:
    print "Usage: %s <all|host [host2 host3 ...]>" % sys.argv[0]
    sys.exit(1)
  elif sys.argv[1] == "all":
    gindent(gformat.get_proxylist() + gformat.get_nodelist())
  else:
    gindent(sys.argv[1:])

