#!/usr/bin/env python
#
# Script to output (stdout) a list of active nodes
# 
# Credits:
# Richard van Mansom <richardvm@wirelessleiden.nl>
# Rick van der Zwet <rick@wirelessleiden.nl>

import gformat

def is_iris(node):
  return node.has_key('release') and node['release'] in ['8.0-RELEASE', '7.2-RELEASE', '8.1-RELEASE', '8.2-RELEASE', '9.0-RELEASE', '10.1-RELEASE']

def is_up(datadump):
  return datadump['status'] == 'up'

if __name__ == '__main__':
  # Process all hosts
  for host in gformat.get_hostlist():
    datadump = gformat.get_yaml(host)

    # Make sure to process only active IRIS nodes
    if not is_iris(datadump) or not is_up(datadump):
      continue

    print host

