#!/bin/sh
#
# $Id: genesis-check.sh 7306 2009-12-02 20:43:28Z rick $
# Check for valid genesis syntax
# Rick van der Zwet, 2009
REPOS="$1"
TXN="$2"

TMPDIR=`mktemp -d -t $(basename $0 .sh)`
# External definition used for debugging
SVNLOOK="${SVNLOOK:-/usr/local/bin/svnlook --transaction $TXN}"
GENESISDIR='node-config/genesis/nodes'

# Check whether we need to check something first
$SVNLOOK changed $REPOS | grep -q $GENESISDIR
if [ $? -eq 1 ]; then
  exit 0
fi

echo "Checking genesis config, please hold your horses..." 1>&2
for ENTRY in `$SVNLOOK tree --full-paths $REPOS $GENESISDIR`; do
  echo $ENTRY | grep -q '/$'
  if [ $? -eq 0 ]; then
    mkdir -p $TMPDIR/$ENTRY
  else
    $SVNLOOK cat $REPOS $ENTRY > $TMPDIR/$ENTRY
  fi
done

# Do actual checking
sh $TMPDIR/$GENESISDIR/before-commit.sh 2>> $TMPDIR/log.txt 1>>$TMPDIR/log.txt
RETVAL=$?

sed "s+$TMPDIR/node-config/genesis/nodes/++g" $TMPDIR/log.txt 1>&2

# Clean up
rm -R $TMPDIR

exit $RETVAL
