#!/bin/sh
#
# dubbelipcheck.sh
# Scriptje om in de wleiden.conf files van Wireless Leiden
# te controleren of er geen dubbele ip addressen bestaan
#
# Rick van der Zwet (rick@wirelessleiden.nl)
genesis_nodes_dir="."
allowed_dubbel_ip="172.31.255.1 172.31.255.2"
tmp_files="all_ips all_ips_no_double"

#zoek alle ip address in de files op
init()
{
	files=`find $genesis_nodes_dir/*/wleiden.conf | grep -e "[A-Z]Node\|proxy"`
	
	master_ips=`cat $files | grep '^$master_ip' |\
						sed -e 's/$master_ip='\''//' -e 's/'\'\;'//'`
	link_ips=`cat $files | grep ^IP | grep -v '$master_ip' |\
					sed -e 's/IP=//' -e 's/\/[0-9]*//'`
	echo "$master_ips $link_ips" | sort > all_ips
	echo "$master_ips $link_ips" | sort -u > all_ips_no_double
}


#check up dubbele ip addressen
dubbelIpCheck() {
	dubbel_ips=`comm -23 all_ips all_ips_no_double | sort -u`
}


#verwijder toegestane dubbele ip's
verwijderToegestaneIps() {
	for allowed in $allowed_dubbel_ip; do
		dubbel_ips=`echo $dubbel_ips | sed s/$allowed//`
	done
}


#print resultaten
results() {
	if [ "$dubbel_ips" ]; then
		for dubbel_ip in $dubbel_ips ; do
			echo ""
			echo "Dubbel ip gevonden: $dubbel_ip"
			echo "Wordt gebruikt in:"
			for file in $files ; do
				grep $dubbel_ip $file | grep "^IP\|^$master_ip" > /dev/null && echo "  -$file"
			done
		done
	else
		echo "Geen dubbele ip's gevonden"
	fi
	echo ""
	echo "Toegestane dubbele ip's:"
	for ip in $allowed_dubbel_ip ; do
		echo "   -$ip"
	done
}


#verwijder tijdelijke files
cleanup() {
	for file in $tmp_files ; do
		rm $file
	done
}



#hoofdmodule
main() {
	init
	dubbelIpCheck
	verwijderToegestaneIps
	results
	cleanup
}

main
exit 0

